/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeComboBox;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeDialogPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeListModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.UserInputTypeValidation;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ArrayTypePanel
extends TypeDialogPanel {
    private TypeComboBox baseTypes;
    private JTextArea preview;
    private JSpinner numberElements;

    public ArrayTypePanel(Component parent, TypeManager typeManager) {
        this(parent, typeManager, null);
    }

    public ArrayTypePanel(Component parent, TypeManager typeManager, BaseType existingType) {
        super(parent, typeManager, existingType);
        this.createControls();
        this.populateControls();
    }

    private void createControls() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)contentPanel, "Center");
        GridBagLayout gbl_m_contentPanel = new GridBagLayout();
        gbl_m_contentPanel.columnWidths = new int[]{0, 0, 0};
        gbl_m_contentPanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_m_contentPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_m_contentPanel.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        contentPanel.setLayout(gbl_m_contentPanel);
        JLabel lblSize = new JLabel("Number of elements:");
        GridBagConstraints gbc_lblSize = new GridBagConstraints();
        gbc_lblSize.anchor = 17;
        gbc_lblSize.insets = new Insets(0, 0, 5, 5);
        gbc_lblSize.gridx = 0;
        gbc_lblSize.gridy = 1;
        contentPanel.add((Component)lblSize, gbc_lblSize);
        this.numberElements = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.numberElements.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                ArrayTypePanel.this.updatePreview();
            }
        });
        GridBagConstraints gbc_numberElements = new GridBagConstraints();
        gbc_numberElements.anchor = 17;
        gbc_numberElements.insets = new Insets(0, 0, 5, 0);
        gbc_numberElements.gridx = 1;
        gbc_numberElements.gridy = 1;
        contentPanel.add((Component)this.numberElements, gbc_numberElements);
        JLabel lblFillWith = new JLabel("Element type:");
        GridBagConstraints gbc_lblFillWith = new GridBagConstraints();
        gbc_lblFillWith.anchor = 17;
        gbc_lblFillWith.insets = new Insets(0, 0, 5, 5);
        gbc_lblFillWith.gridx = 0;
        gbc_lblFillWith.gridy = 0;
        contentPanel.add((Component)lblFillWith, gbc_lblFillWith);
        this.baseTypes = new TypeComboBox(new TypeListModel(this.typeManager.getTypes(), new TypeListModel.PrototypesFilter()));
        this.baseTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ArrayTypePanel.this.updatePreview();
            }
        });
        GridBagConstraints gbc_baseTypes = new GridBagConstraints();
        gbc_baseTypes.insets = new Insets(0, 0, 5, 0);
        gbc_baseTypes.fill = 2;
        gbc_baseTypes.gridx = 1;
        gbc_baseTypes.gridy = 0;
        contentPanel.add((Component)this.baseTypes, gbc_baseTypes);
        JLabel lblPreview = new JLabel("Preview:");
        GridBagConstraints gbc_lblPreview = new GridBagConstraints();
        gbc_lblPreview.anchor = 17;
        gbc_lblPreview.insets = new Insets(0, 0, 5, 5);
        gbc_lblPreview.gridx = 0;
        gbc_lblPreview.gridy = 2;
        contentPanel.add((Component)lblPreview, gbc_lblPreview);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(null);
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 1;
        gbc_scrollPane.gridy = 2;
        contentPanel.add((Component)scrollPane, gbc_scrollPane);
        this.preview = new JTextArea();
        this.preview.setEditable(false);
        scrollPane.setViewportView(this.preview);
    }

    private Integer getNumberElements() {
        return (Integer)this.numberElements.getValue();
    }

    private BaseType getSelectedType() {
        if (this.baseTypes.getSelectedIndex() != -1) {
            TypeListModel model = this.baseTypes.getModel();
            return (BaseType)model.getSelectedItem();
        }
        return null;
    }

    private void populateControls() {
        if (this.existingType == null) {
            return;
        }
        TypeMember arrayMember = this.existingType.iterator().next();
        this.numberElements.setValue(arrayMember.getNumberOfElements().get());
        this.baseTypes.getModel().selectByBaseType(arrayMember.getBaseType());
        this.updatePreview();
    }

    private void updatePreview() {
        if (!UserInputTypeValidation.validateComboBox(this.baseTypes)) {
            return;
        }
        this.preview.setText(String.format("%s my_new_type[%d];", this.getSelectedType().getName(), this.getNumberElements()));
    }

    @Override
    protected void updateExistingType() throws CouldntSaveDataException {
        this.typeManager.updateArray(this.existingType, this.getSelectedType(), this.getNumberElements());
    }

    @Override
    protected void createNewType() throws CouldntSaveDataException {
        this.typeManager.createArray(this.getSelectedType(), this.getNumberElements());
    }

    @Override
    protected boolean validateModel() {
        return UserInputTypeValidation.validateComboBox(this.parent, this.baseTypes);
    }
}

