/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CNodeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CNodeTypeCounter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CSelectionHistoryTreeNode;
import com.google.security.zynamics.binnavi.disassembly.CNodesDisplayString;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.jtree.IconNodeRenderer;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.HtmlGenerator;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTree;

public final class CSelectionTreeCellRenderer
extends IconNodeRenderer {
    private static final long serialVersionUID = -3075353420167960940L;
    private static final Color NORMAL_FONT_COLOR = new Color(0, 0, 0);
    private static final Color INVISIBLE_FONT_COLOR = new Color(128, 128, 128);
    private static final Color SELECTED_FONT_COLOR = new Color(160, 0, 0);
    private static final Color MIXED_STATE_GROUP_NODE_COLOR = new Color(160, 120, 120);

    private String buildToolTip(NaviNode node) {
        ZyLabelContent content = node.getRealizer().getNodeContent();
        return HtmlGenerator.getHtml(content, GuiHelper.getMonospaceFont(), true);
    }

    private String buildToolTip(List<NaviNode> nodes) {
        StringBuilder tooltip = new StringBuilder("<html>");
        boolean first = true;
        for (NaviNode graphNode : nodes) {
            if (!first) {
                tooltip.append("<br>");
            }
            tooltip.append(CNodesDisplayString.getDisplayString(graphNode));
            first = false;
        }
        String string2 = String.valueOf(tooltip);
        return new StringBuilder(7 + String.valueOf(string2).length()).append(string2).append("</html>").toString();
    }

    private void renderHistoryTreeNode(CSelectionHistoryTreeNode treeNode) {
        if (!treeNode.isRoot()) {
            List<NaviNode> nodes = treeNode.getSnapshot().getSelection();
            Pair<Integer, Integer> result = CNodeTypeCounter.count(nodes);
            int countAll = nodes.size();
            int selected = result.first();
            int unselected = countAll - selected;
            int invisible = result.second();
            if (countAll == selected) {
                this.setForeground(SELECTED_FONT_COLOR);
            } else if (countAll == unselected) {
                this.setForeground(NORMAL_FONT_COLOR);
            } else if (countAll == invisible) {
                this.setForeground(INVISIBLE_FONT_COLOR);
            } else {
                this.setForeground(MIXED_STATE_GROUP_NODE_COLOR);
            }
            this.setToolTipText(this.buildToolTip(nodes));
        }
    }

    private void renderLeafNode(CNodeNode treeNode) {
        NaviNode graphNode = treeNode.getNode();
        if (graphNode.isSelected() && graphNode.isVisible()) {
            this.setForeground(SELECTED_FONT_COLOR);
        } else if (!graphNode.isVisible()) {
            this.setForeground(INVISIBLE_FONT_COLOR);
        }
        this.setToolTipText(this.buildToolTip(graphNode));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setBackgroundSelectionColor(Color.WHITE);
        this.setBorderSelectionColor(Color.WHITE);
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setForeground(NORMAL_FONT_COLOR);
        if (value instanceof CSelectionHistoryTreeNode) {
            this.renderHistoryTreeNode((CSelectionHistoryTreeNode)value);
        } else if (value instanceof CNodeNode) {
            this.renderLeafNode((CNodeNode)value);
        }
        return this;
    }
}

