/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo;

import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CNodeTypeCounter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CSelectionHistoryNodeWrapper;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CSelectionSnapshot;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.jtree.IconNode;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class CSelectionHistoryTreeNode
extends IconNode {
    private static final long serialVersionUID = -7628040230460801915L;
    private static final ImageIcon ICON_ROOT = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/root.png"));
    private static final ImageIcon ICON_ALL_UNSELECTED_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_all_unselected.png"));
    private static final ImageIcon ICON_ALL_SELECTED_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_open.png"));
    private static final ImageIcon ICON_ALL_INVISIBLE_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_all_unselected_gray.png"));
    private static final ImageIcon ICON_ALL_UNSELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_all_unselected_halfgray.png"));
    private static final ImageIcon ICON_ALL_VISIBLE_SOME_SELECTED_SOME_UNSELECTED_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_some_unselected.png"));
    private static final ImageIcon ICON_SOME_SELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_some_unselected_halfgray.png"));
    private static final ImageIcon ICON_EMPTY_FOLDER = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_empty.png"));
    private static final ImageIcon ICON_DUMMY = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_closed.png"));
    private final CSelectionSnapshot m_snapshot;
    private final boolean m_root;

    public CSelectionHistoryTreeNode(CSelectionSnapshot snapshot, int stateIndex) {
        super(new CSelectionHistoryNodeWrapper(snapshot, stateIndex));
        this.m_snapshot = snapshot;
        this.m_root = false;
    }

    public CSelectionHistoryTreeNode(String name) {
        super(name);
        this.m_snapshot = new CSelectionSnapshot(new ArrayList<NaviNode>());
        this.m_root = true;
    }

    private static Icon getIcon(int countAll, int selected, int unselected, int invisible) {
        if (countAll == 0) {
            return ICON_EMPTY_FOLDER;
        }
        if (invisible == countAll) {
            return ICON_ALL_INVISIBLE_GRAPHNODES;
        }
        if (selected == countAll) {
            return ICON_ALL_SELECTED_GRAPHNODES;
        }
        if (unselected == countAll && invisible == 0) {
            return ICON_ALL_UNSELECTED_GRAPHNODES;
        }
        if (selected == 0) {
            return ICON_ALL_UNSELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES;
        }
        if (invisible == 0) {
            return ICON_ALL_VISIBLE_SOME_SELECTED_SOME_UNSELECTED_GRAPHNODES;
        }
        if (invisible != 0 && selected != 0) {
            return ICON_SOME_SELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES;
        }
        return ICON_DUMMY;
    }

    @Override
    public Icon getIcon() {
        if (this.m_root) {
            return ICON_ROOT;
        }
        Pair<Integer, Integer> result = CNodeTypeCounter.count(this.m_snapshot.getSelection());
        int countAll = this.m_snapshot.getSelection().size();
        int selected = result.first();
        int unselected = countAll - selected;
        int invisible = result.second();
        return CSelectionHistoryTreeNode.getIcon(countAll, selected, unselected, invisible);
    }

    public CSelectionSnapshot getSnapshot() {
        return this.m_snapshot;
    }
}

