/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CNodeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CSelectionHistory;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CSelectionHistoryTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CSelectionSnapshot;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CSelectionTreeCellRenderer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CUndoTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.ISelectionHistoryListener;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphSelectionListener;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.MoveFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.ZoomFunctions;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public final class CSelectionHistoryChooser
extends JPanel {
    private static final long serialVersionUID = 7667801745468915909L;
    private final ZyGraph m_graph;
    private final CSelectionHistory m_selectionHistory;
    private final JTree m_tree;
    private DefaultTreeModel m_model;
    private int m_stateIndex = 0;
    private final InternalGraphSelectionListener m_graphSelectionListener = new InternalGraphSelectionListener();
    private final InternalTreeSelectionListener m_treeSelectionListener = new InternalTreeSelectionListener();
    private final InternalTreeMouseListener m_treeMouseListener = new InternalTreeMouseListener();
    private final InternalSelectionHistoryListener m_selectionHistoryListener = new InternalSelectionHistoryListener();

    public CSelectionHistoryChooser(ZyGraph graph, CSelectionHistory selectionHistory) {
        super(new GridLayout(1, 0));
        this.m_graph = graph;
        this.m_selectionHistory = selectionHistory;
        selectionHistory.addHistoryListener(this.m_selectionHistoryListener);
        this.m_tree = this.createUndoTree();
        this.add(new JScrollPane(this.m_tree));
        this.m_graph.addListener(this.m_graphSelectionListener);
        this.m_tree.addTreeSelectionListener(this.m_treeSelectionListener);
        this.m_tree.addMouseListener(this.m_treeMouseListener);
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.setBorder(new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), "Selection History"));
    }

    private JTree createUndoTree() {
        CSelectionHistoryTreeNode rootNode = new CSelectionHistoryTreeNode("Selection History");
        CUndoTree tree = new CUndoTree(rootNode);
        this.m_model = (DefaultTreeModel)tree.getModel();
        tree.getSelectionModel().setSelectionMode(1);
        tree.setRootVisible(true);
        tree.setCellRenderer(new CSelectionTreeCellRenderer());
        return tree;
    }

    private void insertSnapshot(CSelectionSnapshot snapshot) {
        CSelectionHistoryTreeNode selection = new CSelectionHistoryTreeNode(snapshot, this.m_stateIndex);
        for (NaviNode node : snapshot.getSelection()) {
            selection.add(new CNodeNode(node));
        }
        ++this.m_stateIndex;
        this.m_model.insertNodeInto(selection, (CSelectionHistoryTreeNode)this.m_model.getRoot(), 0);
    }

    private void selectNodes(List<NaviNode> toSelect) {
        this.m_graph.removeListener(this.m_graphSelectionListener);
        this.m_graph.selectNodes(this.m_graph.getSelectedNodes(), false);
        this.m_graph.selectNodes(toSelect, true);
        this.m_graph.addListener(this.m_graphSelectionListener);
    }

    private void unselectNodes(List<NaviNode> toUnselect) {
        this.m_graph.removeListener(this.m_graphSelectionListener);
        this.m_graph.selectNodes(toUnselect, false);
        this.m_graph.addListener(this.m_graphSelectionListener);
    }

    public void dispose() {
        this.m_selectionHistory.removeHistoryListener(this.m_selectionHistoryListener);
        this.m_graph.removeListener(this.m_graphSelectionListener);
        this.m_tree.removeMouseListener(this.m_treeMouseListener);
        this.m_tree.removeTreeSelectionListener(this.m_treeSelectionListener);
        this.m_tree.setSelectionModel(new DefaultTreeSelectionModel());
    }

    private class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)CSelectionHistoryChooser.this.m_tree.getLastSelectedPathComponent();
            if (node == null || node.isLeaf()) {
                return;
            }
            int childIndex = CSelectionHistoryChooser.this.m_model.getIndexOfChild(CSelectionHistoryChooser.this.m_model.getRoot(), node) == -1 ? 0 : CSelectionHistoryChooser.this.m_model.getIndexOfChild(CSelectionHistoryChooser.this.m_model.getRoot(), node);
            int index = CSelectionHistoryChooser.this.m_selectionHistory.size() - childIndex - 1;
            CSelectionSnapshot snapshot = CSelectionHistoryChooser.this.m_selectionHistory.getSnapshot(index);
            CSelectionHistoryChooser.this.selectNodes(snapshot.getSelection());
        }
    }

    private class InternalTreeMouseListener
    extends MouseAdapter {
        private InternalTreeMouseListener() {
        }

        private TreePath getTreePath(MouseEvent event) {
            return CSelectionHistoryChooser.this.m_tree.getPathForLocation(event.getX(), event.getY());
        }

        private void handleRightClick(int clickCount, NaviNode node) {
            if (clickCount == 1) {
                MoveFunctions.centerNode(CSelectionHistoryChooser.this.m_graph, node);
            } else if (clickCount == 2) {
                ZoomFunctions.zoomToNode(CSelectionHistoryChooser.this.m_graph, node);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            TreePath path = this.getTreePath(event);
            if (path == null) {
                return;
            }
            if (event.getButton() == 1) {
                Object obj = path.getLastPathComponent();
                if (obj instanceof CSelectionHistoryTreeNode) {
                    CSelectionHistoryTreeNode treenode = (CSelectionHistoryTreeNode)obj;
                    List<NaviNode> selection = treenode.getSnapshot().getSelection();
                    if (new HashSet<NaviNode>(selection).equals(CSelectionHistoryChooser.this.m_graph.getSelectedNodes())) {
                        CSelectionHistoryChooser.this.unselectNodes(selection);
                    } else {
                        CSelectionHistoryChooser.this.selectNodes(selection);
                    }
                } else if (obj instanceof CNodeNode) {
                    CNodeNode treenode = (CNodeNode)obj;
                    NaviNode graphNode = treenode.getNode();
                    boolean graphNodeSelected = graphNode.getRawNode().isSelected();
                    CSelectionHistoryChooser.this.m_graph.removeListener(CSelectionHistoryChooser.this.m_graphSelectionListener);
                    CSelectionHistoryChooser.this.m_graph.selectNode(graphNode, !graphNodeSelected);
                    CSelectionHistoryChooser.this.m_graph.addListener(CSelectionHistoryChooser.this.m_graphSelectionListener);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            TreePath path = this.getTreePath(event);
            if (path == null) {
                return;
            }
            if (event.getButton() == 3) {
                CNodeNode treenode;
                NaviNode graphNode;
                Object obj = path.getLastPathComponent();
                if (obj instanceof CSelectionHistoryTreeNode) {
                    CSelectionHistoryTreeNode treenode2 = (CSelectionHistoryTreeNode)obj;
                    CSelectionSnapshot snapshot = treenode2.getSnapshot();
                    List<NaviNode> nodes = CollectionHelpers.filter(snapshot.getSelection(), new ICollectionFilter<NaviNode>(){

                        @Override
                        public boolean qualifies(NaviNode item) {
                            return item.isSelected() && item.isVisible();
                        }
                    });
                    if (nodes.size() > 1) {
                        ZoomFunctions.zoomToNodes(CSelectionHistoryChooser.this.m_graph, nodes);
                    } else if (nodes.size() == 1) {
                        this.handleRightClick(event.getClickCount(), nodes.get(0));
                    }
                } else if (obj instanceof CNodeNode && (graphNode = (treenode = (CNodeNode)obj).getNode()).isVisible()) {
                    this.handleRightClick(event.getClickCount(), graphNode);
                }
            }
        }
    }

    private class InternalSelectionHistoryListener
    implements ISelectionHistoryListener {
        private InternalSelectionHistoryListener() {
        }

        @Override
        public void finishedRedo() {
            CSelectionHistoryChooser.this.m_graph.addListener(CSelectionHistoryChooser.this.m_graphSelectionListener);
        }

        @Override
        public void finishedUndo() {
            CSelectionHistoryChooser.this.m_graph.addListener(CSelectionHistoryChooser.this.m_graphSelectionListener);
        }

        @Override
        public void snapshotAdded(CSelectionSnapshot undoSelection) {
            CSelectionHistoryChooser.this.insertSnapshot(undoSelection);
        }

        @Override
        public void snapshotRemoved() {
            CSelectionHistoryTreeNode root = (CSelectionHistoryTreeNode)CSelectionHistoryChooser.this.m_model.getRoot();
            int children = root.getChildCount();
            CSelectionHistoryTreeNode nodeToDelete = (CSelectionHistoryTreeNode)CSelectionHistoryChooser.this.m_model.getChild(root, children - 1);
            CSelectionHistoryChooser.this.m_model.removeNodeFromParent(nodeToDelete);
        }

        @Override
        public void startedRedo() {
            CSelectionHistoryChooser.this.m_graph.removeListener(CSelectionHistoryChooser.this.m_graphSelectionListener);
        }

        @Override
        public void startedUndo() {
            CSelectionHistoryChooser.this.m_graph.removeListener(CSelectionHistoryChooser.this.m_graphSelectionListener);
        }
    }

    private class InternalGraphSelectionListener
    implements IZyGraphSelectionListener {
        private CSelectionSnapshot lastSnapshot;

        private InternalGraphSelectionListener() {
        }

        @Override
        public void selectionChanged() {
            CSelectionSnapshot snapshot = new CSelectionSnapshot(CSelectionHistoryChooser.this.m_graph.getSelectedNodes());
            if (snapshot.size() != 0 && !snapshot.equals(this.lastSnapshot)) {
                CSelectionHistoryChooser.this.m_selectionHistory.addSnapshot(snapshot);
                this.lastSnapshot = snapshot;
            }
        }
    }
}

