/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CSelectionSnapshot;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.ISelectionHistoryListener;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public final class CSelectionHistory {
    private final ZyGraph m_graph;
    private final int m_maxSnapshots;
    private final List<CSelectionSnapshot> m_snapshotList = new ArrayList<CSelectionSnapshot>();
    private final ListenerProvider<ISelectionHistoryListener> m_listeners = new ListenerProvider();
    private int m_undoIndex = -1;

    public CSelectionHistory(ZyGraph graph, int maxSnapshots) {
        this.m_graph = Preconditions.checkNotNull(graph, "IE01813: Graph argument can not be null");
        Preconditions.checkArgument(maxSnapshots > 0, "IE01814: Invalid maximum snapshot number");
        this.m_maxSnapshots = maxSnapshots;
    }

    public void addHistoryListener(ISelectionHistoryListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void addSnapshot(CSelectionSnapshot snapshot) {
        this.m_snapshotList.add(snapshot);
        if (this.m_snapshotList.size() > this.m_maxSnapshots) {
            this.m_snapshotList.remove(0);
            for (ISelectionHistoryListener listener : this.m_listeners) {
                listener.snapshotRemoved();
            }
        }
        this.m_undoIndex = this.size() - 1;
        for (ISelectionHistoryListener listener : this.m_listeners) {
            listener.snapshotAdded(snapshot);
        }
    }

    public boolean canRedo() {
        return this.m_undoIndex <= this.size() - 1;
    }

    public boolean canUndo() {
        return this.m_undoIndex >= 0;
    }

    public CSelectionSnapshot getSnapshot(int index) {
        return this.m_snapshotList.get(index);
    }

    public CSelectionSnapshot getUndoSnapshot(boolean undo) {
        if (undo) {
            if (this.m_undoIndex != 0) {
                --this.m_undoIndex;
            }
            return this.getSnapshot(this.m_undoIndex);
        }
        if (this.m_undoIndex != this.size() - 1) {
            ++this.m_undoIndex;
        }
        return this.getSnapshot(this.m_undoIndex);
    }

    public void redo() {
        for (ISelectionHistoryListener listener : this.m_listeners) {
            try {
                listener.startedRedo();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_graph.selectNodes(this.m_graph.getSelectedNodes(), false);
        this.m_graph.selectNodes(this.getUndoSnapshot(false).getSelection(), true);
        for (ISelectionHistoryListener listener : this.m_listeners) {
            try {
                listener.finishedRedo();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void removeHistoryListener(ISelectionHistoryListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public int size() {
        return this.m_snapshotList.size();
    }

    public void undo() {
        for (ISelectionHistoryListener listener : this.m_listeners) {
            try {
                listener.startedUndo();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_graph.selectNodes(this.m_graph.getSelectedNodes(), false);
        this.m_graph.selectNodes(this.getUndoSnapshot(true).getSelection(), true);
        for (ISelectionHistoryListener listener : this.m_listeners) {
            try {
                listener.finishedUndo();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

