/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.SearchResult;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CNodeTypeSwitcher;
import com.google.security.zynamics.binnavi.disassembly.algorithms.INodeTypeCallback;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.io.Serializable;
import java.util.Comparator;

public final class CSearchResultComparator
implements Comparator<SearchResult>,
Serializable {
    private static final long serialVersionUID = -4131554230719995844L;

    private IAddress getAddress(NaviEdge edge) {
        return this.getAddress(((NaviNode)edge.getSource()).getRawNode());
    }

    private IAddress getAddress(INaviViewNode node) {
        return CNodeTypeSwitcher.switchNode(node, new INodeTypeCallback<IAddress>(){

            @Override
            public IAddress handle(INaviCodeNode node) {
                return node.getAddress();
            }

            @Override
            public IAddress handle(INaviFunctionNode node) {
                return node.getAddress();
            }

            @Override
            public IAddress handle(INaviGroupNode node) {
                return CSearchResultComparator.this.getAddress(node.getElements().get(0));
            }

            @Override
            public IAddress handle(INaviTextNode node) {
                return CSearchResultComparator.this.getAddress((INaviViewNode)node.getChildren().get(0));
            }
        });
    }

    @Override
    public int compare(SearchResult first, SearchResult second) {
        IAddress firstAddress = null;
        IAddress secondAddress = null;
        if (first.getObject() instanceof NaviEdge) {
            firstAddress = this.getAddress((NaviEdge)first.getObject());
        } else if (first.getObject() instanceof NaviNode) {
            firstAddress = this.getAddress(((NaviNode)first.getObject()).getRawNode());
        }
        if (second.getObject() instanceof NaviEdge) {
            secondAddress = this.getAddress((NaviEdge)second.getObject());
        } else if (second.getObject() instanceof NaviNode) {
            secondAddress = this.getAddress(((NaviNode)second.getObject()).getRawNode());
        }
        if (firstAddress == null || secondAddress == null) {
            throw new IllegalStateException("IE01155: Address can't be null.");
        }
        return firstAddress.toBigInteger().compareTo(secondAddress.toBigInteger());
    }
}

