/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.SearchResult;
import java.util.ArrayList;
import java.util.List;

public final class CGraphSearchResultsCursor {
    private boolean m_isAfterLast = false;
    private boolean m_isBeforeFirst = false;
    private int m_currentSearchIndex = -1;
    private final List<SearchResult> m_reducedResults = new ArrayList<SearchResult>();
    private List<SearchResult> m_results;

    private void removeDuplicates() {
        this.m_reducedResults.clear();
        Object last = null;
        for (SearchResult r2 : this.m_results) {
            if (last == r2.getObject()) continue;
            last = r2.getObject();
            this.m_reducedResults.add(r2);
        }
    }

    public void clear() {
        this.m_reducedResults.clear();
        this.m_currentSearchIndex = 0;
    }

    public SearchResult current() {
        return this.m_reducedResults.isEmpty() ? null : this.m_reducedResults.get(this.m_currentSearchIndex);
    }

    public boolean isAfterLast() {
        return this.m_isAfterLast;
    }

    public boolean isBeforeFirst() {
        return this.m_isBeforeFirst;
    }

    public void jumpTo(int resultIndex) {
        this.m_currentSearchIndex = 0;
        SearchResult previousResult = this.m_results.get(0);
        for (int i2 = 1; i2 <= resultIndex; ++i2) {
            SearchResult currentResult = this.m_results.get(i2);
            if (previousResult.getObject() != currentResult.getObject()) {
                ++this.m_currentSearchIndex;
            }
            previousResult = currentResult;
        }
        if (this.m_currentSearchIndex >= this.m_reducedResults.size()) {
            throw new IllegalStateException();
        }
    }

    public void next() {
        if (this.current() == null) {
            return;
        }
        ++this.m_currentSearchIndex;
        this.m_isBeforeFirst = false;
        this.m_isAfterLast = false;
        if (this.m_currentSearchIndex == this.m_reducedResults.size()) {
            this.m_currentSearchIndex = 0;
            this.m_isAfterLast = true;
        }
    }

    public void previous() {
        if (this.current() == null) {
            return;
        }
        --this.m_currentSearchIndex;
        this.m_isBeforeFirst = false;
        this.m_isAfterLast = false;
        if (this.m_currentSearchIndex < 0) {
            this.m_currentSearchIndex = this.m_reducedResults.size() - 1;
            this.m_isBeforeFirst = true;
        }
    }

    public void reset() {
        this.m_currentSearchIndex = 0;
    }

    public void setResults(List<SearchResult> results) {
        this.m_results = new ArrayList<SearchResult>(results);
        this.removeDuplicates();
    }
}

