/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.SearchResult;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CElementSearcher {
    private CElementSearcher() {
    }

    private static int doRegexSearch(Object element, String lineText, int lineCounter, String localSearchString, int startPosition, boolean caseSensitive, List<SearchResult> results) {
        Pattern pattern = caseSensitive ? Pattern.compile(localSearchString) : Pattern.compile(localSearchString, 2);
        Matcher matcher = pattern.matcher(lineText);
        boolean found = matcher.find(startPosition);
        if (found) {
            int end;
            int start = matcher.start();
            if (start != (end = matcher.end())) {
                results.add(new SearchResult(element, lineCounter, start, end - start));
            }
            if (matcher.end() == lineText.length()) {
                return -1;
            }
            if (start == end) {
                return end + 1;
            }
            return end;
        }
        return -1;
    }

    private static int doTextSearch(Object element, String lineText, int lineCounter, String localSearchString, int startPosition, boolean caseSensitive, List<SearchResult> results) {
        int index = lineText.indexOf(caseSensitive ? localSearchString : localSearchString.toLowerCase(), startPosition);
        if (index == -1) {
            return -1;
        }
        results.add(new SearchResult(element, lineCounter, index, localSearchString.length()));
        return index + localSearchString.length();
    }

    public static List<SearchResult> search(Object element, ZyLabelContent content, String searchString, boolean regEx, boolean caseSensitive) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        if ("".equals(searchString)) {
            return results;
        }
        int lineCounter = 0;
        for (ZyLineContent lineContent : content) {
            String lineText = caseSensitive ? lineContent.getText() : lineContent.getText().toLowerCase();
            int startPosition = 0;
            while ((startPosition = regEx ? CElementSearcher.doRegexSearch(element, lineText, lineCounter, searchString, startPosition, caseSensitive, results) : CElementSearcher.doTextSearch(element, lineText, lineCounter, searchString, startPosition, caseSensitive, results)) != -1) {
            }
            ++lineCounter;
        }
        return results;
    }
}

