/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Gui;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.SearchResult;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Model.GraphSearcher;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraphHelpers;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import java.awt.Color;
import java.awt.Window;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxEditor;

public final class CSearchExecuter {
    private static final Color BACKGROUND_COLOR_FAIL = new Color(255, 128, 128);
    private static final Color BACKGROUND_COLOR_SUCCESS = Color.WHITE;

    private CSearchExecuter() {
    }

    private static void cycleExistingSearch(Window parent, ZyGraph graph, GraphSearcher searcher, boolean cycleBackwards, boolean zoomToResult) {
        SearchResult result;
        if (cycleBackwards) {
            searcher.getCursor().previous();
            if (searcher.getCursor().isBeforeFirst()) {
                CMessageBox.showInformation(parent, "All search results were displayed. Going back to the last one");
            }
        } else {
            searcher.getCursor().next();
            if (searcher.getCursor().isAfterLast()) {
                CMessageBox.showInformation(parent, "All search results were displayed. Going back to the first one");
            }
        }
        if ((result = searcher.getCursor().current()) == null) {
            return;
        }
        if (result.getObject() instanceof NaviNode) {
            ZyGraphHelpers.centerNode(graph, (NaviNode)result.getObject(), zoomToResult);
        } else if (result.getObject() instanceof NaviEdge) {
            ZyGraphHelpers.centerEdgeLabel(graph, (NaviEdge)result.getObject(), zoomToResult);
        }
    }

    private static void startNewSearch(Window parent, ComboBoxEditor editor, ZyGraph graph, GraphSearcher searcher, String searchString, boolean zoomToResult) {
        try {
            searcher.search(GraphHelpers.getNodes(graph), GraphHelpers.getEdges(graph), searchString);
            if (searcher.getResults().isEmpty()) {
                editor.getEditorComponent().setBackground(BACKGROUND_COLOR_FAIL);
            } else {
                editor.getEditorComponent().setBackground(BACKGROUND_COLOR_SUCCESS);
            }
            for (SearchResult result : searcher.getResults()) {
                if (result.getObject() instanceof NaviNode) {
                    NaviNode node = (NaviNode)result.getObject();
                    node.setBackgroundColor(result.getLine(), result.getPosition(), result.getLength(), Color.YELLOW);
                    continue;
                }
                if (!(result.getObject() instanceof NaviEdge)) continue;
                NaviEdge edge = (NaviEdge)result.getObject();
                edge.getLabelContent().getLineContent(result.getLine()).setBackgroundColor(result.getPosition(), result.getLength(), Color.YELLOW);
            }
            SearchResult result = searcher.getCursor().current();
            if (result != null) {
                if (result.getObject() instanceof NaviNode) {
                    ZyGraphHelpers.centerNode(graph, (NaviNode)result.getObject(), zoomToResult);
                } else if (result.getObject() instanceof NaviEdge) {
                    ZyGraphHelpers.centerEdgeLabel(graph, (NaviEdge)result.getObject(), zoomToResult);
                }
            }
            graph.updateGraphViews();
        }
        catch (PatternSyntaxException exception) {
            CMessageBox.showInformation(parent, String.format("Invalid Regular Expression '%s'", searchString));
        }
    }

    public static void search(Window parent, ComboBoxEditor editor, ZyGraph graph, GraphSearcher searcher, String searchString, boolean cycleBackwards, boolean zoomToResult) {
        if (searcher.hasChanged() || !searchString.equals(searcher.getLastSearchString())) {
            CSearchExecuter.startNewSearch(parent, editor, graph, searcher, searchString, zoomToResult);
        } else if (!searcher.getResults().isEmpty()) {
            CSearchExecuter.cycleExistingSearch(parent, graph, searcher, cycleBackwards, zoomToResult);
        }
    }
}

