/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Goto;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Goto.CAddressSelectionTableModel;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class CAddressSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 2832808324997248079L;
    private INaviModule m_selectionResult;
    private JTable m_table;
    private final List<INaviModule> m_modules;
    private final InternalListener m_listener = new InternalListener();

    public CAddressSelectionDialog(JFrame owner, List<INaviModule> m_modules2) {
        super((Window)owner, "Select a graph", Dialog.ModalityType.APPLICATION_MODAL);
        Preconditions.checkNotNull(m_modules2, "IE01392: Function list can't be null");
        this.m_modules = new ArrayList<INaviModule>(m_modules2);
        this.createGui(m_modules2);
        new CDialogEscaper(this);
        this.setLocationRelativeTo(null);
    }

    private void closeDialog() {
        this.m_table.removeMouseListener(this.m_listener);
        this.setVisible(false);
        this.dispose();
    }

    private void createGui(List<INaviModule> modules) {
        this.setLayout(new BorderLayout());
        JTextArea field = new JTextArea("The current graph has more then one module.\nPlease choose the one to search in.");
        field.setEditable(false);
        this.add((Component)field, "North");
        this.m_table = new JTable(new CAddressSelectionTableModel(modules));
        this.m_table.addMouseListener(this.m_listener);
        this.add((Component)new JScrollPane(this.m_table), "Center");
        CPanelTwoButtons panel = new CPanelTwoButtons(this.m_listener, "OK", "Cancel");
        this.add((Component)panel, "South");
        this.setSize(500, 300);
    }

    public INaviModule getSelectionResult() {
        return this.m_selectionResult;
    }

    private class InternalListener
    extends MouseAdapter
    implements ActionListener {
        private InternalListener() {
        }

        private void setSelectedElement() {
            int selectedRow = CAddressSelectionDialog.this.m_table.getSelectedRow();
            if (selectedRow != -1) {
                CAddressSelectionDialog.this.m_selectionResult = (INaviModule)CAddressSelectionDialog.this.m_modules.get(selectedRow);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                this.setSelectedElement();
            }
            CAddressSelectionDialog.this.closeDialog();
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                this.setSelectedElement();
            }
            if (CAddressSelectionDialog.this.m_selectionResult != null) {
                CAddressSelectionDialog.this.closeDialog();
            }
        }
    }
}

