/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.Center;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.Synchronizers.CBreakpointSynchronizer;
import com.google.security.zynamics.binnavi.Gui.Debug.Synchronizers.CNodeSynchronizer;
import com.google.security.zynamics.binnavi.Gui.Debug.Synchronizers.CThreadEventSynchronizer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;

public final class CGraphSynchronizer {
    private final ZyGraph m_graph;
    private final CDebugPerspectiveModel m_debugPerspective;
    private final IDebugPerspectiveModelListener m_debugListener = new InternalDebugListener();
    private CBreakpointSynchronizer m_breakpointSynchronizer;
    private CThreadEventSynchronizer m_threadEventSynchronizer;

    public CGraphSynchronizer(ZyGraph graph, CDebugPerspectiveModel debugPerspective) {
        this.m_graph = Preconditions.checkNotNull(graph, "IE02330: graph argument can not be null");
        this.m_debugPerspective = Preconditions.checkNotNull(debugPerspective, "IE02331: debugPerspective argument can not be null");
        debugPerspective.addListener(this.m_debugListener);
        this.synchronizeDebugger(null, debugPerspective.getCurrentSelectedDebugger());
    }

    private void synchronizeDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
        if (oldDebugger != null) {
            this.m_breakpointSynchronizer.dispose();
            this.m_threadEventSynchronizer.dispose();
        }
        if (newDebugger != null) {
            this.m_breakpointSynchronizer = new CBreakpointSynchronizer(newDebugger.getBreakpointManager(), this.m_graph);
            this.m_threadEventSynchronizer = new CThreadEventSynchronizer(newDebugger, this.m_graph);
            new CNodeSynchronizer(newDebugger.getBreakpointManager(), this.m_graph, this.m_debugPerspective);
        }
    }

    public void dispose() {
        this.m_debugPerspective.removeListener(this.m_debugListener);
        this.synchronizeDebugger(this.m_debugPerspective.getCurrentSelectedDebugger(), null);
    }

    private class InternalDebugListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebugListener() {
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            CGraphSynchronizer.this.synchronizeDebugger(oldDebugger, newDebugger);
        }
    }
}

