/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Debug.Notifier.CDebugEventNotifier;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IFrontEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceLogger;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.HashMap;
import java.util.Map;

public final class CDebugPerspectiveModel
implements IFrontEndDebuggerProvider {
    private final IGraphModel m_model;
    private IDebugger m_activeDebugger = null;
    private IAddress m_activeAddress = null;
    private final ListenerProvider<IDebugPerspectiveModelListener> m_listeners = new ListenerProvider();
    private final Map<IDebugger, TraceLogger> m_eventLoggerMap = new HashMap<IDebugger, TraceLogger>();
    private final Map<IDebugger, CDebugEventNotifier> m_notifierMap = new HashMap<IDebugger, CDebugEventNotifier>();
    private IAddress m_gotoAddress = null;

    public CDebugPerspectiveModel(IGraphModel model) {
        this.m_model = Preconditions.checkNotNull(model, "IE01804: Graph model argument can not be null");
    }

    public void addListener(IDebugPerspectiveModelListener listener) {
        this.m_listeners.addListener(listener);
    }

    public IAddress getActiveAddress() {
        return this.m_activeAddress;
    }

    @Override
    public IDebugger getCurrentSelectedDebugger() {
        return this.m_activeDebugger;
    }

    public IAddress getGotoAddress() {
        return this.m_gotoAddress;
    }

    public IGraphModel getGraphModel() {
        return this.m_model;
    }

    @Override
    public CDebugEventNotifier getNotifier(IDebugger debugger) {
        return this.m_notifierMap.get(debugger);
    }

    @Override
    public TraceLogger getTraceLogger(IDebugger debugger) {
        return this.m_eventLoggerMap.get(debugger);
    }

    public void removeListener(IDebugPerspectiveModelListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setActiveDebugger(IDebugger debugger) {
        if (this.m_activeDebugger == debugger) {
            return;
        }
        if (debugger != null && !this.m_eventLoggerMap.containsKey(debugger)) {
            this.m_notifierMap.put(debugger, new CDebugEventNotifier(this.m_model.getParent(), debugger, this.m_model.getDebuggerProvider().getDebugTarget(), this.m_model.getViewContainer()));
            this.m_eventLoggerMap.put(debugger, new TraceLogger(this.m_model.getViewContainer().getTraceProvider(), debugger));
        }
        IDebugger oldDebugger = this.m_activeDebugger;
        this.m_activeDebugger = debugger;
        for (IDebugPerspectiveModelListener listener : this.m_listeners) {
            try {
                listener.changedActiveDebugger(oldDebugger, this.m_activeDebugger);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setActiveMemoryAddress(IAddress address, boolean focusMemoryWindow) {
        if (address != null && address.equals(this.m_activeAddress)) {
            return;
        }
        if (address == null && this.m_activeAddress == null) {
            return;
        }
        this.m_activeAddress = address;
        for (IDebugPerspectiveModelListener listener : this.m_listeners) {
            try {
                listener.changedActiveAddress(this.m_activeAddress, focusMemoryWindow);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setGotoAddress(IAddress address) {
        this.m_gotoAddress = address;
    }
}

