/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.DragAndDrop.CDefaultTransferHandler;
import com.google.security.zynamics.binnavi.Gui.DragAndDrop.IDropHandler;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Actions.CAddRootTagNodeAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagTreeCellRenderer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagsTreeModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.DragDrop.CTagSortingHandler;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Implementations.CTagFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTagTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTaggedGraphNodeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTaggedGraphNodesContainerNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.ITagTreeNode;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Help.CHelpFunctions;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.binnavi.Help.IHelpProvider;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.NodeTaggingTree.Nodes.CRootTagTreeNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import com.google.security.zynamics.zylib.gui.dndtree.DNDTree;
import com.google.security.zynamics.zylib.gui.jtree.TreeHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphSelectionListener;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphVisibilityListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.MoveFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.ZoomFunctions;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class CTagsTree
extends DNDTree
implements IHelpProvider {
    private static final long serialVersionUID = -1074808285623025354L;
    private final JFrame m_parent;
    private final ZyGraph m_graph;
    private final ITagManager m_tagManager;
    private final CTagsTreeModel m_model;
    private final CRootTagTreeNode m_rootNode;
    private final InternalMouseListener m_mouseListener = new InternalMouseListener();
    private final InternalGraphSelectionListener m_graphSelectionListener = new InternalGraphSelectionListener();
    private final InternalGraphVisibilityListener m_graphVisibilityListener = new InternalGraphVisibilityListener();
    private TreePath m_lastValidSelectionPath = null;
    private CTagTreeNode m_lastValidSelectedNode = null;

    public CTagsTree(JFrame parent, ZyGraph graph, ITagManager manager) {
        this.m_parent = Preconditions.checkNotNull(parent, "IE02308: Perent argument can not be null");
        this.m_graph = Preconditions.checkNotNull(graph, "IE01776: Graph can not be null");
        this.m_tagManager = Preconditions.checkNotNull(manager, "IE01777: Manager argument can not be null");
        this.m_model = new CTagsTreeModel(this);
        this.setModel(this.m_model);
        this.getModel().addTreeModelListener(new InternalModelListener());
        this.addMouseListener(this.m_mouseListener);
        this.m_graph.addListener(this.m_graphSelectionListener);
        this.m_graph.addListener(this.m_graphVisibilityListener);
        this.setRootVisible(false);
        this.m_rootNode = new CRootTagTreeNode(parent, this, graph, this.m_tagManager);
        this.m_model.setRoot(this.m_rootNode);
        this.setCellRenderer(new CTagTreeCellRenderer());
        this.m_model.nodeStructureChanged(this.m_rootNode);
        ArrayList<IDropHandler> handlers2 = new ArrayList<IDropHandler>();
        handlers2.add(new CTagSortingHandler());
        new CDefaultTransferHandler((DNDTree)this, 3, handlers2);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.setSelectionModel(selectionModel);
        InputMap windowImap = this.getInputMap(0);
        windowImap.put(HotKeys.DELETE_HK.getKeyStroke(), "DELETE");
        this.getActionMap().put("DELETE", CActionProxy.proxy(new DeleteAction()));
    }

    private void showPopupMenu(MouseEvent event) {
        ITagTreeNode selectedNode = (ITagTreeNode)TreeHelpers.getNodeAt(this, event.getX(), event.getY());
        if (selectedNode == null) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(CActionProxy.proxy(new CAddRootTagNodeAction(this.m_parent, this.m_tagManager, this.m_rootNode.getTag())));
            popupMenu.show(this, event.getX(), event.getY());
        } else {
            JPopupMenu menu = selectedNode.getPopupMenu();
            if (menu != null) {
                menu.show(this, event.getX(), event.getY());
            }
        }
    }

    public void dispose() {
        this.m_rootNode.dispose();
        this.removeMouseListener(this.m_mouseListener);
        this.m_graph.removeListener(this.m_graphSelectionListener);
        this.m_graph.removeListener(this.m_graphVisibilityListener);
    }

    @Override
    public IHelpInformation getHelpInformation() {
        return new IHelpInformation(){

            @Override
            public String getText() {
                return "This tree is used to configure and assign node tags. Once you have assigned tags to nodes you can use this tree to quickly select all nodes tagged with given tags.";
            }

            @Override
            public URL getUrl() {
                return CHelpFunctions.urlify("main_window.htm");
            }
        };
    }

    @Override
    public CTagsTreeModel getModel() {
        return this.m_model;
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CTagsTree.this.showPopupMenu(event);
            } else {
                int y2 = event.getY();
                int x2 = event.getX();
                TreePath path = CTagsTree.this.getPathForLocation(x2, y2);
                if (path == null) {
                    return;
                }
                Object treenode = path.getLastPathComponent();
                if (event.getButton() == 1) {
                    if (treenode instanceof CTagTreeNode) {
                        CTagsTree.this.m_lastValidSelectedNode = (CTagTreeNode)treenode;
                        CTagsTree.this.m_lastValidSelectionPath = path;
                        ((CTagTreeCellRenderer)CTagsTree.this.getCellRenderer()).setSelectedNode(CTagsTree.this.m_lastValidSelectedNode);
                    } else if (treenode instanceof CTaggedGraphNodesContainerNode) {
                        CTaggedGraphNodesContainerNode containerNode = (CTaggedGraphNodesContainerNode)treenode;
                        List<NaviNode> nodes = containerNode.getGraphNodes();
                        boolean select2 = false;
                        int countunselected = 0;
                        int countinvisible = 0;
                        for (NaviNode nn : nodes) {
                            if (!nn.getRawNode().isSelected()) {
                                select2 = true;
                                ++countunselected;
                            }
                            if (nn.getRawNode().isVisible()) continue;
                            ++countinvisible;
                        }
                        if (!(countinvisible != countunselected && select2 || CTagsTree.this.m_graph.getSettings().getProximitySettings().getProximityBrowsingFrozen())) {
                            CTagsTree.this.m_graph.selectNodes(nodes, select2);
                        } else {
                            ArrayList<NaviNode> visiblenodes = new ArrayList<NaviNode>();
                            for (NaviNode nn : nodes) {
                                if (!nn.isVisible()) continue;
                                visiblenodes.add(nn);
                            }
                            CTagsTree.this.m_graph.selectNodes(visiblenodes, select2);
                        }
                    } else if (treenode instanceof CTaggedGraphNodeNode) {
                        CTaggedGraphNodeNode graphNode = (CTaggedGraphNodeNode)treenode;
                        boolean graphNodeSelected = graphNode.getGraphNode().getRawNode().isSelected();
                        if (!CTagsTree.this.m_graph.getSettings().getProximitySettings().getProximityBrowsingFrozen() || graphNode.getGraphNode().isVisible()) {
                            CTagsTree.this.m_graph.selectNode(graphNode.getGraphNode(), !graphNodeSelected);
                        }
                    }
                    new SwingInvoker(){

                        @Override
                        protected void operation() {
                            CTagsTree.this.getSelectionModel().setSelectionPath(CTagsTree.this.m_lastValidSelectionPath);
                        }
                    }.invokeLater();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            CTaggedGraphNodeNode treeNode;
            NaviNode graphNode;
            if (event.isPopupTrigger()) {
                CTagsTree.this.showPopupMenu(event);
            }
            int y2 = event.getY();
            int x2 = event.getX();
            TreePath path = CTagsTree.this.getPathForLocation(x2, y2);
            if (path == null) {
                return;
            }
            Object treenode = path.getLastPathComponent();
            if (event.getButton() == 3 && treenode instanceof CTaggedGraphNodeNode && (graphNode = (treeNode = (CTaggedGraphNodeNode)treenode).getGraphNode()).isVisible()) {
                if (event.getClickCount() == 1) {
                    MoveFunctions.centerNode(CTagsTree.this.m_graph, graphNode);
                } else if (event.getClickCount() == 2) {
                    ZoomFunctions.zoomToNode(CTagsTree.this.m_graph, graphNode);
                }
            }
        }
    }

    private class InternalModelListener
    implements TreeModelListener {
        private InternalModelListener() {
        }

        private void update() {
            if (CTagsTree.this.m_lastValidSelectedNode == null) {
                CTagsTree.this.validate();
            } else {
                Integer tagId = (Integer)CTagsTree.this.m_lastValidSelectedNode.getUserObject();
                Enumeration<TreeNode> nodes = CTagsTree.this.m_rootNode.breadthFirstEnumeration();
                while (nodes.hasMoreElements()) {
                    final DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                    if (!Objects.equals(node.getUserObject(), tagId)) continue;
                    new SwingInvoker(){

                        @Override
                        protected void operation() {
                            CTagsTree.this.m_lastValidSelectionPath = new TreePath(CTagsTree.this.getModel().getPathToRoot(node));
                            CTagsTree.this.getSelectionModel().setSelectionPath(CTagsTree.this.m_lastValidSelectionPath);
                        }
                    };
                    return;
                }
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent event) {
            this.update();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent event) {
            this.update();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent event) {
            this.update();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent event) {
            this.update();
        }
    }

    private class InternalGraphVisibilityListener
    implements IZyGraphVisibilityListener {
        private InternalGraphVisibilityListener() {
        }

        @Override
        public void nodeDeleted() {
        }

        @Override
        public void visibilityChanged() {
        }
    }

    private class InternalGraphSelectionListener
    implements IZyGraphSelectionListener {
        private InternalGraphSelectionListener() {
        }

        @Override
        public void selectionChanged() {
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object component = CTagsTree.this.getLastSelectedPathComponent();
            if (component instanceof CTagTreeNode) {
                CTagFunctions.deleteTag(CTagsTree.this.m_parent, CTagsTree.this.m_tagManager, ((CTagTreeNode)component).getTag());
            }
        }
    }
}

