/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeChooser;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public final class CNodeChooserModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1300798042465396160L;
    private static final String[] COLUMNNAMES = new String[]{"In", "Out", "Node", "Color"};
    public static final int COLUMN_IN = 0;
    public static final int COLUMN_OUT = 1;
    public static final int COLUMN_ADDRESS = 2;
    public static final int COLUMN_COLOR = 3;
    private final ZyGraph m_graph;
    private List<INaviViewNode> m_nodeCache;

    public CNodeChooserModel(ZyGraph graph) {
        this.m_graph = Preconditions.checkNotNull(graph, "IE01765: Graph argument can not be null");
        this.m_nodeCache = CollectionHelpers.filter(this.getNodes(), new NodeFilter());
    }

    private String getNodeAddress(INaviViewNode node) {
        if (node instanceof INaviFunctionNode) {
            return ((INaviFunctionNode)node).getAddress().toHexString();
        }
        if (node instanceof INaviCodeNode) {
            return ((INaviCodeNode)node).getAddress().toHexString();
        }
        return null;
    }

    private List<INaviViewNode> getNodes() {
        if (this.m_nodeCache != null) {
            return this.m_nodeCache;
        }
        return this.m_graph.getRawView().getGraph().getNodes();
    }

    @Override
    public int getColumnCount() {
        return COLUMNNAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMNNAMES[col];
    }

    @Override
    public int getRowCount() {
        if (this.m_nodeCache == null) {
            this.m_nodeCache = CollectionHelpers.filter(this.getNodes(), new NodeFilter());
        }
        return this.m_nodeCache.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return this.getNodeAddress(this.m_nodeCache.get(rowIndex));
            }
            case 3: {
                return this.m_nodeCache.get(rowIndex).getColor().getRGB();
            }
            case 0: {
                return this.m_nodeCache.get(rowIndex).getIncomingEdges().size();
            }
            case 1: {
                return this.m_nodeCache.get(rowIndex).getOutgoingEdges().size();
            }
        }
        return null;
    }

    public void reset() {
        this.m_nodeCache = null;
        this.fireTableDataChanged();
    }

    public void addNode(INaviViewNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        Preconditions.checkArgument(!this.m_nodeCache.contains(node), "Error: node can not be added more then once");
        this.m_nodeCache.add(node);
        int index = this.m_nodeCache.indexOf(node);
        this.fireTableRowsInserted(index, index);
    }

    public void changedNode(IViewNode<?> node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        int index = this.m_nodeCache.indexOf(node);
        this.fireTableRowsUpdated(index, index);
    }

    public void deleteNode(INaviViewNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        int index = this.m_nodeCache.indexOf(node);
        Preconditions.checkArgument(index != -1, "Error: the node is not known to the model");
        this.m_nodeCache.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void deleteNodes(Collection<INaviViewNode> nodes) {
        Preconditions.checkNotNull(nodes, "Error: nodes argument can not be null");
        for (INaviViewNode node : nodes) {
            this.deleteNode(node);
        }
    }

    private static class NodeFilter
    implements ICollectionFilter<INaviViewNode> {
        private NodeFilter() {
        }

        @Override
        public boolean qualifies(INaviViewNode node) {
            return node instanceof INaviFunctionNode || node instanceof INaviCodeNode;
        }
    }
}

