/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu;

import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionDeleteInvisibleNodes;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionDeleteSelectedNodes;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionDeleteUnselectedNodes;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionGraphSettings;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionInsertView;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionShowDataflow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionShowProximityBrowsingSettingsDialog;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionShowReil;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.disassembly.CProjectContainer;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleContainer;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Actions.CActionInlineAll;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public final class CGraphMenu
extends JMenu {
    private static final long serialVersionUID = 4694180868761680353L;

    public CGraphMenu(CGraphWindow parent, ZyGraph graph, IViewContainer container, JCheckBoxMenuItem proximityBrowsingMenu, JCheckBoxMenuItem autoLayoutMenu) {
        super("Graph");
        ZyGraphViewSettings settings = graph.getSettings();
        this.setMnemonic("HK_MENU_GRAPH".charAt(0));
        autoLayoutMenu.setSelected(settings.getLayoutSettings().getAutomaticLayouting());
        this.add(autoLayoutMenu);
        proximityBrowsingMenu.setSelected(settings.getProximitySettings().getProximityBrowsing());
        this.add(proximityBrowsingMenu);
        this.addSeparator();
        this.add(CActionProxy.proxy(new CActionGraphSettings(parent, graph)));
        this.add(CActionProxy.proxy(new CActionShowProximityBrowsingSettingsDialog(parent, graph.getSettings())));
        this.addSeparator();
        this.add(CActionProxy.proxy(new CActionInsertView(parent, graph, container)));
        this.addSeparator();
        this.add(CActionProxy.proxy(new CActionDeleteSelectedNodes(graph, false)));
        this.add(CActionProxy.proxy(new CActionDeleteUnselectedNodes(graph)));
        this.add(CActionProxy.proxy(new CActionDeleteInvisibleNodes(graph)));
        this.addSeparator();
        JMenu transformMenu = new JMenu("Transform");
        transformMenu.add(CActionProxy.proxy(new CActionInlineAll(parent, container, graph)));
        if (container instanceof CModuleContainer || container instanceof CProjectContainer) {
            transformMenu.addSeparator();
            transformMenu.add(CActionProxy.proxy(new CActionShowReil(parent, container, container.getModules().get(0), graph.getRawView())));
        }
        transformMenu.add(CActionProxy.proxy(new CActionShowDataflow(parent, container, graph.getRawView())));
        this.add(transformMenu);
    }
}

