/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.Gui.CNameShortener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.ButtonTab.ButtonTabComponent;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.ButtonTab.IButtonTabListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CPanelCloser;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import java.awt.Color;
import java.awt.Component;
import java.util.LinkedHashMap;
import javax.swing.JTabbedPane;

public final class JGraphTab
extends JTabbedPane {
    private static final long serialVersionUID = 6366240643759928623L;
    private final InternalTabClickListener m_listener = new InternalTabClickListener();
    private final CGraphWindow m_parent;
    private final LinkedHashMap<Integer, Integer> moduleIdCount = new LinkedHashMap();

    public JGraphTab(CGraphWindow parent) {
        super(1, 1);
        this.m_parent = Preconditions.checkNotNull(parent, "IE01638: Parent argument can not be null");
    }

    @Override
    public synchronized void addTab(String title, Component component) {
        Preconditions.checkNotNull(title, "IE01639: Title argument can not be null");
        Preconditions.checkNotNull(component, "IE01640: Component argument can not be null");
        super.addTab(title, component);
        this.setSelectedComponent(component);
        int moduleId = ((IGraphPanel)((Object)component)).getModel().getViewContainer().getModules().get(0).getConfiguration().getId();
        if (!this.moduleIdCount.containsKey(moduleId)) {
            this.moduleIdCount.put(moduleId, 1);
        } else {
            this.moduleIdCount.put(moduleId, this.moduleIdCount.get(moduleId) + 1);
        }
        ButtonTabComponent buttonTab = new ButtonTabComponent(this);
        buttonTab.addListener(this.m_listener);
        this.setTabComponentAt(this.getSelectedIndex(), buttonTab);
    }

    @Override
    public Color getBackgroundAt(int index) {
        IGraphPanel panel = (IGraphPanel)((Object)this.getComponentAt(index));
        if (this.moduleIdCount.size() > 1) {
            return this.selectTabBackGroundColor(panel.getModel().getViewContainer().getModules().get(0).getConfiguration().getId());
        }
        return super.getBackgroundAt(index);
    }

    public void updateRegisterHeaders() {
        for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
            IGraphPanel component = (IGraphPanel)((Object)this.getComponentAt(i2));
            this.setTitleAt(i2, CNameShortener.shorten(component.getModel().getGraph().getRawView()));
        }
    }

    private Color selectTabBackGroundColor(int seed) {
        int insertionPosition = Iterables.indexOf(this.moduleIdCount.keySet(), Predicates.equalTo(seed));
        switch (insertionPosition) {
            case 0: {
                return Color.getHSBColor(0.55f, 0.2f, 0.8f);
            }
            case 1: {
                return Color.getHSBColor(0.6f, 0.2f, 0.8f);
            }
            case 2: {
                return Color.getHSBColor(0.65f, 0.2f, 0.8f);
            }
            case 3: {
                return Color.getHSBColor(0.7f, 0.2f, 0.8f);
            }
            case 4: {
                return Color.getHSBColor(0.75f, 0.2f, 0.8f);
            }
            case 5: {
                return Color.getHSBColor(0.8f, 0.2f, 0.8f);
            }
            case 6: {
                return Color.getHSBColor(0.85f, 0.2f, 0.8f);
            }
            case 7: {
                return Color.getHSBColor(0.9f, 0.2f, 0.8f);
            }
            case 8: {
                return Color.getHSBColor(0.95f, 0.2f, 0.8f);
            }
            case 9: {
                return Color.getHSBColor(1.0f, 0.2f, 0.8f);
            }
            case 10: {
                return Color.getHSBColor(0.05f, 0.2f, 0.8f);
            }
            case 11: {
                return Color.getHSBColor(0.1f, 0.2f, 0.8f);
            }
            case 12: {
                return Color.getHSBColor(0.15f, 0.2f, 0.8f);
            }
            case 13: {
                return Color.getHSBColor(0.2f, 0.2f, 0.8f);
            }
            case 14: {
                return Color.getHSBColor(0.25f, 0.2f, 0.8f);
            }
            case 15: {
                return Color.getHSBColor(0.3f, 0.2f, 0.8f);
            }
            case 16: {
                return Color.getHSBColor(0.35f, 0.2f, 0.8f);
            }
            case 17: {
                return Color.getHSBColor(0.4f, 0.2f, 0.8f);
            }
            case 18: {
                return Color.getHSBColor(0.45f, 0.2f, 0.8f);
            }
            case 19: {
                return Color.getHSBColor(0.5f, 0.2f, 0.8f);
            }
        }
        return Color.WHITE;
    }

    private class InternalTabClickListener
    implements IButtonTabListener {
        private InternalTabClickListener() {
        }

        @Override
        public boolean closing(ButtonTabComponent btc) {
            int openWindows = JGraphTab.this.getTabCount();
            for (int i2 = 0; i2 < openWindows; ++i2) {
                if (btc != JGraphTab.this.getTabComponentAt(i2)) continue;
                IGraphPanel panel = (IGraphPanel)((Object)JGraphTab.this.getComponentAt(i2));
                if (CPanelCloser.closeTab(JGraphTab.this.m_parent, panel)) {
                    btc.removeListener(JGraphTab.this.m_listener);
                    int moduleId = panel.getModel().getViewContainer().getModules().get(0).getConfiguration().getId();
                    if ((Integer)JGraphTab.this.moduleIdCount.get(moduleId) == 1) {
                        JGraphTab.this.moduleIdCount.remove(moduleId);
                    } else {
                        JGraphTab.this.moduleIdCount.put(moduleId, (Integer)JGraphTab.this.moduleIdCount.get(moduleId) - 1);
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

