/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.gui.zygraph.functions.NodeFunctions;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;

public final class CNodeDeleter {
    private CNodeDeleter() {
    }

    private static void connectParentsWithChildren(INaviView view, INaviViewNode node) {
        List<INaviEdge> incomingEdges = node.getIncomingEdges();
        List children = node.getChildren();
        for (INaviEdge incomingEdge : incomingEdges) {
            if (incomingEdge.getSource() == node) continue;
            for (INaviViewNode child : children) {
                if (child == node || CNodeDeleter.hasEdge((INaviViewNode)incomingEdge.getSource(), child, incomingEdge.getType())) continue;
                view.getContent().createEdge((INaviViewNode)incomingEdge.getSource(), child, incomingEdge.getType());
            }
        }
    }

    private static List<NaviNode> filterHiddenNodes(Collection<NaviNode> nodes) {
        return CollectionHelpers.filter(nodes, new ICollectionFilter<NaviNode>(){

            @Override
            public boolean qualifies(NaviNode node) {
                return node.getRawNode().getParentGroup() == null || !node.getRawNode().getParentGroup().isCollapsed();
            }
        });
    }

    private static boolean hasEdge(INaviViewNode source, INaviViewNode target, EdgeType type) {
        for (INaviEdge edge : source.getOutgoingEdges()) {
            if (edge.getTarget() != target || edge.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static void deleteInstruction(JFrame parent, ZyGraph graph, NaviNode node, INaviInstruction instruction) {
        if (0 == CMessageBox.showYesNoCancelQuestion(parent, String.format("Do you really want to delete the instruction '%s' from the code node?", instruction.getInstructionString()))) {
            INaviCodeNode rawNode = (INaviCodeNode)node.getRawNode();
            if (!rawNode.hasInstruction(instruction)) {
                CMessageBox.showError(parent, "The instruction is not part of the code node");
                return;
            }
            if (Iterables.size(rawNode.getInstructions()) == 1) {
                CNodeDeleter.connectParentsWithChildren(graph.getRawView(), node.getRawNode());
                graph.deleteNodes(Lists.newArrayList(node));
            } else {
                ((INaviCodeNode)node.getRawNode()).removeInstruction(instruction);
            }
        }
    }

    public static void deleteInvisibleNodes(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01729: Graph argument can not be null");
        graph.deleteNodes(NodeFunctions.getInvisibleNodes(graph));
    }

    public static void deleteNode(INaviView view, INaviViewNode node) {
        Preconditions.checkNotNull(view, "IE01730: View argument can not be null");
        Preconditions.checkNotNull(node, "IE01731: Node argument can not be null");
        view.getContent().deleteNode(node);
    }

    public static void removeSelectedNodes(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01732: Graph argument can not be null");
        List<NaviNode> selectedNodes = CNodeDeleter.filterHiddenNodes(graph.getSelectedNodes());
        graph.deleteNodes(selectedNodes);
    }

    public static void removeSelectedNodesKeepEdges(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01733: Graph argument can not be null");
        List<NaviNode> selectedNodes = CNodeDeleter.filterHiddenNodes(graph.getSelectedNodes());
        for (NaviNode naviNode : selectedNodes) {
            CNodeDeleter.connectParentsWithChildren(graph.getRawView(), naviNode.getRawNode());
        }
        graph.deleteNodes(selectedNodes);
    }

    public static void removeUnselectedNodes(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01734: Graph argument can not be null");
        List<NaviNode> unselectedNodes = CNodeDeleter.filterHiddenNodes(GraphHelpers.getUnselectedNodes(graph));
        graph.deleteNodes(unselectedNodes);
    }
}

