/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.CDefaultModifier;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyInstructionBuilder;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CStyleRunData;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CLineGrayer {
    private final Set<IInstruction> m_grayedInstructions = new HashSet<IInstruction>();

    private void grayLine(CGraphModel model, NaviNode node, INaviCodeNode codeNode, double y2) {
        double yPos = y2 - node.getY();
        int row = node.positionToRow(yPos);
        INaviInstruction instruction = CCodeNodeHelpers.lineToInstruction(codeNode, row);
        if (instruction == null) {
            return;
        }
        if (this.m_grayedInstructions.contains(instruction)) {
            Pair<String, List<CStyleRunData>> content = ZyInstructionBuilder.buildInstructionLine(instruction, model.getGraph().getSettings(), new CDefaultModifier(model.getGraph().getSettings(), model.getDebuggerProvider()));
            for (CStyleRunData style : content.second()) {
                node.setColor(row, style.getStart(), style.getLength(), style.getColor());
            }
            this.m_grayedInstructions.remove(instruction);
        } else {
            node.setColor(row, Color.LIGHT_GRAY);
            this.m_grayedInstructions.add(instruction);
        }
    }

    public void handleGrayLine(CGraphModel model, NaviNode node, double y2) {
        if (node.getRawNode() instanceof INaviCodeNode) {
            this.grayLine(model, node, (INaviCodeNode)node.getRawNode(), y2);
        }
    }
}

