/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.SelectedVisibleFilter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.MoveFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.ZoomFunctions;
import java.util.List;

public final class CGraphZoomer {
    private CGraphZoomer() {
    }

    private static void checkArguments(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01762: Graph argument can not be null");
    }

    public static void centerNode(ZyGraph graph, NaviNode node) {
        CGraphZoomer.checkArguments(graph);
        MoveFunctions.centerNode(graph, node);
    }

    public static void centerNodeZoomed(ZyGraph graph, NaviNode node) {
        CGraphZoomer.checkArguments(graph);
        MoveFunctions.centerNode(graph, node);
        ZoomFunctions.zoomToNode(graph, node);
    }

    public static void zoomIn(ZyGraph graph) {
        CGraphZoomer.checkArguments(graph);
        graph.zoomIn();
    }

    public static void zoomNode(ZyGraph graph, NaviNode node) {
        CGraphZoomer.checkArguments(graph);
        ZoomFunctions.zoomToNode(graph, node);
    }

    public static void zoomNode(ZyGraph graph, List<NaviNode> nodes) {
        CGraphZoomer.checkArguments(graph);
        ZoomFunctions.zoomToNodes(graph, nodes);
    }

    public static void zoomOut(ZyGraph graph) {
        CGraphZoomer.checkArguments(graph);
        graph.zoomOut();
    }

    public static void zoomSelected(ZyGraph graph) {
        CGraphZoomer.checkArguments(graph);
        if (!graph.getSelectedNodes().isEmpty()) {
            ZoomFunctions.zoomToNodes(graph, SelectedVisibleFilter.filter(graph.getSelectedNodes()));
        }
    }

    public static void zoomToScreen(ZyGraph graph) {
        CGraphZoomer.checkArguments(graph);
        ZoomFunctions.zoomToScreen(graph);
    }
}

