/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphConverters;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.wrappers.SelectableGraph;
import com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms;
import java.util.List;

public final class CGraphSelectionExpander {
    private CGraphSelectionExpander() {
    }

    private static void checkArguments(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01760: Graph argument can not be null");
    }

    public static void expandSelection(ZyGraph graph) {
        CGraphSelectionExpander.checkArguments(graph);
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        GraphHelpers.expandSelectionUp(selectableGraph);
        GraphHelpers.expandSelectionDown(selectableGraph);
    }

    public static void expandSelectionDown(ZyGraph graph) {
        CGraphSelectionExpander.checkArguments(graph);
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        if (graph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
            GraphHelpers.expandSelectionDown(selectableGraph);
        } else {
            List rawNodes = GraphConverters.convert(graph.getSelectedNodes());
            graph.selectNodes(GraphConverters.convert(graph, GraphAlgorithms.getSuccessors(rawNodes, 1)), true);
        }
    }

    public static void expandSelectionUp(ZyGraph graph) {
        CGraphSelectionExpander.checkArguments(graph);
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        if (graph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
            GraphHelpers.expandSelectionUp(selectableGraph);
        } else {
            List rawNodes = GraphConverters.convert(graph.getSelectedNodes());
            graph.selectNodes(GraphConverters.convert(graph, GraphAlgorithms.getPredecessors(rawNodes, 1)), true);
        }
    }

    public static void shrinkSelection(ZyGraph graph) {
        CGraphSelectionExpander.checkArguments(graph);
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        GraphHelpers.shrinkSelectionUp(selectableGraph);
        GraphHelpers.shrinkSelectionDown(selectableGraph);
    }

    public static void shrinkSelectionDown(ZyGraph graph) {
        CGraphSelectionExpander.checkArguments(graph);
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        GraphHelpers.shrinkSelectionDown(selectableGraph);
    }

    public static void shrinkSelectionUp(ZyGraph graph) {
        CGraphSelectionExpander.checkArguments(graph);
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        GraphHelpers.shrinkSelectionUp(selectableGraph);
    }
}

