/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CViewCommentDialog;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CSaveProgress;
import com.google.security.zynamics.binnavi.Gui.Loaders.CViewOpener;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CViewInserter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import java.awt.Window;

public final class CGraphSaver {
    private CGraphSaver() {
    }

    public static void clone(CGraphWindow parent, INaviView view, IViewContainer container) {
        CloneThread cloneThread = new CloneThread(parent, view, container);
        CProgressDialog.showEndless(parent, String.format("Cloning view '%s'", view.getName()), cloneThread);
        if (cloneThread.getException() != null) {
            CUtilityFunctions.logException(cloneThread.getException());
            String innerMessage = "E00118: View could not be cloned";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be cloned.", view.getName()), new String[]{"It is unclear why this problem occurred. Please check the stack trace for more information."}, new String[]{"The view was not cloned."});
            NaviErrorDialog.show(parent, "E00118: View could not be cloned", innerDescription, cloneThread.getException());
        }
    }

    public static CSaveProgress save(final Window parent, final ZyGraph graph) {
        Preconditions.checkNotNull(parent, "IE01752: Parent argument can not be null");
        Preconditions.checkNotNull(graph, "IE01753: Graph argument can not be null");
        final CSaveProgress progress = new CSaveProgress(false);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CViewSaverOperation operation = new CViewSaverOperation(String.format("Saving view '%s'", graph.getRawView().getName()));
                try {
                    if (!graph.save()) {
                        throw new CouldntSaveDataException("Something went wrong saving");
                    }
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                    String innerMessage = "E00120: Could not save graph";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The function '%s' could not be saved.", graph.getRawView().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The graph remains unsaved."});
                    NaviErrorDialog.show(parent, "E00120: Could not save graph", innerDescription, e2);
                }
                finally {
                    operation.stop();
                    progress.setDone();
                }
            }
        }.start();
        return progress;
    }

    public static CSaveProgress saveAs(final Window parent, final ZyGraph graph, final IViewContainer container) {
        Preconditions.checkNotNull(parent, "IE01754: Parent argument can not be null");
        Preconditions.checkNotNull(graph, "IE01755: Graph argument can not be null");
        INaviView view = graph.getRawView();
        CViewCommentDialog dlg = new CViewCommentDialog(parent, "Save", view.getName(), view.getConfiguration().getDescription());
        dlg.setVisible(true);
        if (dlg.wasCancelled()) {
            return new CSaveProgress(true);
        }
        final String newName = dlg.getName();
        final String newDescription = dlg.getComment();
        final CSaveProgress progress = new CSaveProgress(false);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CViewSaverOperation operation = new CViewSaverOperation(String.format("Saving view '%s'", newName));
                try {
                    if (graph.saveAs(container, newName, newDescription) == null) {
                        throw new CouldntSaveDataException("Failure saving the view.");
                    }
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                    String innerMessage = "E00121: Could not save graph";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be saved.", newName), new String[]{"There was a problem with the database connection."}, new String[]{"The new view was not created."});
                    NaviErrorDialog.show(parent, "E00121: Could not save graph", innerDescription, e2);
                }
                finally {
                    operation.stop();
                    progress.setDone();
                }
            }
        }.start();
        return progress;
    }

    private static final class CViewSaverOperation
    implements IProgressOperation {
        private final CProgressPanel m_progressPanel = new CProgressPanel("", true, false);

        public CViewSaverOperation(String description) {
            CGlobalProgressManager.instance().add(this);
            this.m_progressPanel.setText(description);
            this.m_progressPanel.start();
        }

        @Override
        public String getDescription() {
            return "Saving view";
        }

        @Override
        public CProgressPanel getProgressPanel() {
            return this.m_progressPanel;
        }

        public void stop() {
            CGlobalProgressManager.instance().remove(this);
        }
    }

    private static class CloneThread
    extends CEndlessHelperThread {
        private final CGraphWindow m_parent;
        private final INaviView m_view;
        private final IViewContainer m_container;

        private CloneThread(CGraphWindow parent, INaviView view, IViewContainer container) {
            this.m_parent = Preconditions.checkNotNull(parent, "IE02387: parent argument can not be null");
            this.m_view = Preconditions.checkNotNull(view, "IE02388: view argument can not be null");
            this.m_container = Preconditions.checkNotNull(container, "IE02389: container argument can not be null");
        }

        @Override
        protected void runExpensiveCommand() throws Exception {
            INaviView newView = this.m_container.createView(String.format("Clone of %s", this.m_view.getName()), this.m_view.getConfiguration().getDescription());
            CViewInserter.insertView(this.m_view, newView);
            CViewOpener.showView(this.m_parent, this.m_container, newView, this.m_parent);
        }
    }
}

