/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphLayouter;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.CInliningHelper;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CInliningResult;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CReferenceFinder;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;

public final class CGraphInliner {
    private CGraphInliner() {
    }

    private static void exceptionDialog(JFrame parent, INaviFunction function, CouldntLoadDataException e2) {
        CUtilityFunctions.logException(e2);
        String innerMessage = "E00117: Function could not be inlined";
        String innerDescription = CUtilityFunctions.createDescription(String.format("The function '%s' could not be inlined because it could not be loaded.", function.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The graph remains unchanged because the function was not inlined."});
        NaviErrorDialog.show(parent, "E00117: Function could not be inlined", innerDescription, e2);
    }

    private static INaviFunction getFunctionToInline(JFrame parent, IViewContainer viewContainer, INaviFunction function, int forwarderModuleId, IAddress forwarderAddress) {
        if (forwarderAddress == null) {
            return function;
        }
        IDatabase database = viewContainer.getDatabase();
        INaviModule module = database.getContent().getModule(forwarderModuleId);
        if (!viewContainer.containsModule(module)) {
            CMessageBox.showInformation(parent, String.format("You are trying to inline an external function into a module view. This is not possible.\nTo inline external functions it is necessary to create projects.", new Object[0]));
            return null;
        }
        if (!module.isLoaded()) {
            try {
                module.load();
            }
            catch (CouldntLoadDataException | LoadCancelledException e2) {
                CUtilityFunctions.logException(e2);
                return null;
            }
        }
        return module.getContent().getFunctionContainer().getFunction(forwarderAddress);
    }

    private static CInliningResult inlineFunctionSilently(JFrame parent, IViewContainer viewContainer, ZyGraph graph, INaviCodeNode node, INaviInstruction instruction, INaviFunction function) {
        INaviFunction inlineFunction = CGraphInliner.prepareFunctionInlining(parent, node, instruction, function, viewContainer);
        if (inlineFunction == null) {
            return null;
        }
        if (inlineFunction.getBasicBlockCount() == 0) {
            return null;
        }
        try {
            if (!inlineFunction.isLoaded()) {
                inlineFunction.load();
            }
            return CInliningHelper.inlineCodeNode(graph.getRawView(), node, instruction, inlineFunction);
        }
        catch (CouldntLoadDataException e2) {
            CGraphInliner.exceptionDialog(parent, inlineFunction, e2);
            return null;
        }
    }

    private static INaviFunction prepareFunctionInlining(JFrame parent, INaviCodeNode node, INaviInstruction instruction, INaviFunction function, IViewContainer viewContainer) {
        Preconditions.checkNotNull(parent, "IE00825: Parent argument can not be null");
        Preconditions.checkNotNull(viewContainer, "IE00915: View container argument can not be null");
        Preconditions.checkNotNull(node, "IE00916: Node argument can't be null");
        Preconditions.checkNotNull(instruction, "IE01153: Instruction argument can't be null");
        Preconditions.checkNotNull(function, "IE01173: Function argument can't be null");
        int forwarderModuleId = function.getForwardedFunctionModuleId();
        IAddress forwarderAddress = function.getForwardedFunctionAddress();
        return CGraphInliner.getFunctionToInline(parent, viewContainer, function, forwarderModuleId, forwarderAddress);
    }

    public static void inlineAll(JFrame parent, IViewContainer container, ZyGraph graph) {
        Preconditions.checkNotNull(parent, "IE02285: Parent argument can not be null");
        Preconditions.checkNotNull(container, "IE02286: Container argument can not be null");
        Preconditions.checkNotNull(graph, "IE02287: Graph Argument can not be null");
        MutableDirectedGraph mutableGraph = (MutableDirectedGraph)graph.getRawView().getGraph();
        List nodes = mutableGraph.getNodes();
        HashMap<INaviInstruction, INaviFunction> instructionToFunctionMap = new HashMap<INaviInstruction, INaviFunction>();
        for (INaviViewNode iNaviViewNode : nodes) {
            if (!(iNaviViewNode instanceof INaviCodeNode)) continue;
            instructionToFunctionMap.putAll(CReferenceFinder.getCodeReferenceMap((INaviCodeNode)iNaviViewNode));
        }
        for (INaviInstruction iNaviInstruction : instructionToFunctionMap.keySet()) {
            INaviCodeNode updatedNode = null;
            for (INaviViewNode iNaviViewNode2 : graph.getRawView().getGraph().getNodes()) {
                INaviCodeNode codeNode = (INaviCodeNode)iNaviViewNode2;
                if (!codeNode.hasInstruction(iNaviInstruction)) continue;
                updatedNode = codeNode;
            }
            if (updatedNode != null) {
                CGraphInliner.inlineFunctionSilently(parent, container, graph, updatedNode, iNaviInstruction, (INaviFunction)instructionToFunctionMap.get(iNaviInstruction));
                continue;
            }
            throw new IllegalStateException("IE01174: Graph final has been rendered final to an final inconsitant state");
        }
    }

    public static void inlineFunction(JFrame parent, IViewContainer viewContainer, ZyGraph graph, INaviCodeNode node, INaviInstruction instruction, INaviFunction function) {
        INaviFunction inlineFunction = CGraphInliner.prepareFunctionInlining(parent, node, instruction, function, viewContainer);
        if (inlineFunction == null) {
            CMessageBox.showError(parent, "Could not inline the function because it is forwarded to an unknown function.");
        } else if (inlineFunction.getBasicBlockCount() == 0) {
            CMessageBox.showError(parent, "Could not inline the function because it has 0 basic blocks.");
        } else {
            try {
                if (!inlineFunction.isLoaded()) {
                    inlineFunction.load();
                }
                CInliningHelper.inlineCodeNode(graph.getRawView(), node, instruction, inlineFunction);
                if (graph.getSettings().getLayoutSettings().getAutomaticLayouting()) {
                    CGraphLayouter.refreshLayout(parent, graph);
                }
            }
            catch (CouldntLoadDataException e2) {
                CGraphInliner.exceptionDialog(parent, inlineFunction, e2);
            }
        }
    }

    public static void inlineFunction(JFrame parent, ZyGraph graph, INaviFunctionNode node) {
        Preconditions.checkNotNull(parent, "IE01743: Parent argument can not be null");
        Preconditions.checkNotNull(graph, "IE01744: Graph argument can not be null");
        Preconditions.checkNotNull(node, "IE01745: Node argument can not be null");
        INaviView view = graph.getRawView();
        INaviFunction function = node.getFunction();
        try {
            if (!function.isLoaded()) {
                function.load();
            }
            CInliningHelper.inlineFunctionNode(view, node);
            if (graph.getSettings().getLayoutSettings().getAutomaticLayouting()) {
                CGraphLayouter.refreshLayout(parent, graph);
            }
        }
        catch (CouldntLoadDataException e2) {
            CGraphInliner.exceptionDialog(parent, function, e2);
        }
    }
}

