/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class CGraphGrouper {
    private CGraphGrouper() {
    }

    private static boolean allElementsSelected(INaviGroupNode group) {
        return !CollectionHelpers.any(group.getElements(), new ICollectionFilter<INaviViewNode>(){

            @Override
            public boolean qualifies(INaviViewNode node) {
                return !node.isSelected();
            }
        });
    }

    private static String determineNodeText(NaviNode node) {
        if (node.getRawNode() instanceof INaviCodeNode) {
            INaviCodeNode cnode = (INaviCodeNode)node.getRawNode();
            return String.format("Basic Block: %s", cnode.getAddress().toHexString());
        }
        if (node.getRawNode() instanceof INaviFunctionNode) {
            INaviFunctionNode fnode = (INaviFunctionNode)node.getRawNode();
            return String.format("Function: %s (%s)", fnode.getFunction().getName(), fnode.getFunction().getAddress().toHexString());
        }
        if (node.getRawNode() instanceof INaviTextNode) {
            INaviTextNode tnode = (INaviTextNode)node.getRawNode();
            List<IComment> comment = tnode.getComments();
            String firstLine = comment.isEmpty() ? "" : comment.get(1).getComment();
            int firstLineBreak = Math.min(firstLine.indexOf(10), firstLine.indexOf(13));
            int toDisplay = Math.min(Math.min(15, firstLineBreak == -1 ? Integer.MAX_VALUE : firstLineBreak), firstLine.length());
            return String.format("Text: %s", firstLine.substring(0, toDisplay));
        }
        if (node.getRawNode() instanceof INaviGroupNode) {
            INaviGroupNode gnode = (INaviGroupNode)node.getRawNode();
            List<IComment> comment = gnode.getComments();
            String firstLine = comment.isEmpty() ? "" : comment.get(0).getComment();
            int firstLineBreak = Math.min(firstLine.indexOf(10), firstLine.indexOf(13));
            int toDisplay = Math.min(Math.min(15, firstLineBreak == -1 ? Integer.MAX_VALUE : firstLineBreak), firstLine.length());
            return String.format("Group: %s", firstLine.substring(0, toDisplay));
        }
        throw new IllegalStateException("IE01150: Unknown node type");
    }

    private static List<NaviNode> filterSelectedNodes(Collection<NaviNode> nodes) {
        return CollectionHelpers.filter(nodes, new ICollectionFilter<NaviNode>(){

            @Override
            public boolean qualifies(NaviNode node) {
                return node.getRawNode().getParentGroup() == null || !CGraphGrouper.allElementsSelected(node.getRawNode().getParentGroup());
            }
        });
    }

    private static INaviGroupNode getCommonParent(List<NaviNode> nodes) {
        INaviGroupNode parent = null;
        boolean first = true;
        for (NaviNode node : nodes) {
            if (first) {
                parent = node.getRawNode().getParentGroup();
                first = false;
                continue;
            }
            if (parent == node.getRawNode().getParentGroup()) continue;
            return null;
        }
        return parent;
    }

    private static void groupNodes(ZyGraph graph, List<NaviNode> nodes) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<INaviViewNode> rawNodes = new ArrayList<INaviViewNode>();
        INaviGroupNode commonParent = CGraphGrouper.getCommonParent(nodes);
        for (NaviNode node : nodes) {
            if (node.getRawNode().getParentGroup() != null) {
                node.getRawNode().getParentGroup().removeElement(node.getRawNode());
            }
            rawNodes.add(node.getRawNode());
            stringBuilder.append(CGraphGrouper.determineNodeText(node));
            stringBuilder.append('\n');
        }
        CGroupNode groupNode = graph.getRawView().getContent().createGroupNode(rawNodes);
        if (commonParent != null) {
            commonParent.addElement(groupNode);
        }
        try {
            groupNode.appendComment(stringBuilder.toString());
        }
        catch (CouldntLoadDataException | CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
        }
    }

    public static void groupSelectedNodes(ZyGraph graph) {
        List<NaviNode> nodes = CGraphGrouper.filterSelectedNodes(graph.getSelectedNodes());
        if (!nodes.isEmpty()) {
            CGraphGrouper.groupNodes(graph, nodes);
        }
    }

    public static void removeFromGroup(NaviNode node) {
        INaviGroupNode group = node.getRawNode().getParentGroup();
        if (group != null) {
            group.removeElement(node.getRawNode());
            if (group.getParentGroup() != null) {
                group.getParentGroup().addElement(node.getRawNode());
            }
        }
    }

    public static void removeSelectedGroups(ZyGraph graph) {
        for (NaviNode node : graph.getSelectedNodes()) {
            if (!(node.getRawNode() instanceof INaviGroupNode)) continue;
            graph.getRawView().getContent().deleteNode(node.getRawNode());
        }
    }

    public static void toggleSelectedGroups(ZyGraph graph) {
        for (NaviNode node : graph.getSelectedNodes()) {
            INaviGroupNode gnode;
            if (!(node.getRawNode() instanceof INaviGroupNode)) continue;
            gnode.setCollapsed(!(gnode = (INaviGroupNode)node.getRawNode()).isCollapsed());
        }
    }
}

