/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.LastDirFileChooser;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.GraphExporters;
import java.io.IOException;
import javax.swing.JFrame;

public final class CGraphExporter {
    private CGraphExporter() {
    }

    public static void exportAsPng(JFrame parent, ZyGraph graph) {
        Preconditions.checkNotNull(parent, "IE01735: Parent argument can not be null");
        Preconditions.checkNotNull(graph, "IE01736: Graph argument can not be null");
        LastDirFileChooser fileChooser = new LastDirFileChooser();
        int retval = fileChooser.showSaveDialog(parent);
        if (retval == 0) {
            try {
                if (!GraphExporters.exportAllAsPNG(graph, fileChooser.getSelectedFile().getAbsolutePath())) {
                    throw new IOException("Failed to write the PNG");
                }
            }
            catch (IOException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00194: Could not save view to PNG file";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be written to the file '%s'.", graph.getViewName(), fileChooser.getSelectedFile().getAbsolutePath()), new String[]{"There was a problem writing the PNG file."}, new String[]{"The view was not written to the PNG file."});
                NaviErrorDialog.show(parent, "E00194: Could not save view to PNG file", innerDescription, e2);
            }
        }
    }

    public static void exportAsSvg(JFrame parent, ZyGraph graph) {
        Preconditions.checkNotNull(parent, "IE01737: Parent argument can not be null");
        Preconditions.checkNotNull(graph, "IE01738: Graph argument can not be null");
        LastDirFileChooser fileChooser = new LastDirFileChooser();
        int retval = fileChooser.showSaveDialog(parent);
        if (retval == 0) {
            try {
                if (!GraphExporters.exportAllAsSVG(graph, fileChooser.getSelectedFile().getAbsolutePath())) {
                    throw new IOException("Failed to save SVG");
                }
            }
            catch (IOException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00195: Could not save view to SVG file";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be written to the file '%s'.", graph.getViewName(), fileChooser.getSelectedFile().getAbsolutePath()), new String[]{"There was a problem writing the PNG file."}, new String[]{"The view was not written to the PNG file."});
                NaviErrorDialog.show(parent, "E00195: Could not save view to SVG file", innerDescription, e2);
            }
        }
    }
}

