/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import java.util.HashSet;
import java.util.Set;

public final class CGraphDebugger {
    private CGraphDebugger() {
    }

    private static void toggleBreakpoint(BreakpointManager manager, BreakpointAddress address) {
        if (manager.hasBreakpoint(BreakpointType.REGULAR, address)) {
            BreakpointStatus status = manager.getBreakpointStatus(address, BreakpointType.REGULAR);
            if (status == BreakpointStatus.BREAKPOINT_DISABLED) {
                manager.setBreakpointStatus(Sets.newHashSet(address), BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_ENABLED);
            } else if (status == BreakpointStatus.BREAKPOINT_ACTIVE || status == BreakpointStatus.BREAKPOINT_INACTIVE || status == BreakpointStatus.BREAKPOINT_ENABLED || status == BreakpointStatus.BREAKPOINT_HIT) {
                manager.setBreakpointStatus(Sets.newHashSet(address), BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_DISABLED);
            }
        }
    }

    public static BreakpointStatus getBreakpointStatus(BreakpointManager manager, INaviModule module, UnrelocatedAddress unrelocatedAddress) {
        BreakpointAddress address = new BreakpointAddress(module, unrelocatedAddress);
        return manager.getBreakpointStatus(address, BreakpointType.REGULAR);
    }

    public static IDebugger getDebugger(BackEndDebuggerProvider debuggerProvider, INaviFunctionNode functionNode) {
        Preconditions.checkNotNull(debuggerProvider, "IE01706: Debugger provider argument can not be null");
        Preconditions.checkNotNull(functionNode, "IE01707: Function node argument can not be null");
        return debuggerProvider.getDebugger(functionNode.getFunction().getModule());
    }

    public static IDebugger getDebugger(BackEndDebuggerProvider debuggerProvider, INaviInstruction instruction) {
        Preconditions.checkNotNull(debuggerProvider, "IE01704: Debugger provider argument can not be null");
        Preconditions.checkNotNull(instruction, "IE01705: Instruction argument can not be null");
        return debuggerProvider.getDebugger(instruction.getModule());
    }

    public static boolean hasBreakpoint(BreakpointManager manager, INaviModule module, UnrelocatedAddress unrelocatedAddress) {
        BreakpointAddress address = new BreakpointAddress(module, unrelocatedAddress);
        return manager.hasBreakpoint(BreakpointType.REGULAR, address);
    }

    public static void removeBreakpoint(BreakpointManager manager, INaviModule module, UnrelocatedAddress unrelocatedAddress) {
        Preconditions.checkNotNull(manager, "IE01710: Breakpoint manager argument can not be null");
        Preconditions.checkNotNull(module, "IE01711: Module argument can not be null");
        Preconditions.checkNotNull(unrelocatedAddress, "IE01712: Address argument can not be null");
        BreakpointAddress address = new BreakpointAddress(module, unrelocatedAddress);
        if (manager.hasBreakpoint(BreakpointType.REGULAR, address)) {
            CGraphDebugger.removeBreakpoints(Sets.newHashSet(address), manager);
        }
    }

    public static void removeBreakpoints(Set<BreakpointAddress> addresses, BreakpointManager manager) {
        Preconditions.checkNotNull(manager, "IE01708: Manager argument can not be null");
        Preconditions.checkNotNull(addresses, "IE01709: Address argument can not be null");
        HashSet<BreakpointAddress> addressesToRemoveFromManager = new HashSet<BreakpointAddress>();
        HashSet<BreakpointAddress> addressesToRemoveFromDebugger = new HashSet<BreakpointAddress>();
        for (BreakpointAddress address : addresses) {
            BreakpointStatus status = manager.getBreakpointStatus(address, BreakpointType.REGULAR);
            if (status == BreakpointStatus.BREAKPOINT_DISABLED || status == BreakpointStatus.BREAKPOINT_INACTIVE) {
                addressesToRemoveFromManager.add(address);
            }
            if (status == BreakpointStatus.BREAKPOINT_DELETING) continue;
            addressesToRemoveFromDebugger.add(address);
        }
        if (addressesToRemoveFromManager.size() != 0) {
            manager.removeBreakpoints(BreakpointType.REGULAR, addressesToRemoveFromManager);
        }
        if (addressesToRemoveFromDebugger.size() != 0) {
            manager.setBreakpointStatus(addressesToRemoveFromDebugger, BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_DELETING);
        }
    }

    public static void setBreakpoint(BreakpointManager manager, INaviModule module, UnrelocatedAddress unrelocatedAddress) {
        Preconditions.checkNotNull(manager, "IE01713: Manager argument can not be null");
        Preconditions.checkNotNull(module, "IE01714: Module argument can not be null");
        Preconditions.checkNotNull(unrelocatedAddress, "IE01715: Address argument can not be null");
        BreakpointAddress address = new BreakpointAddress(module, unrelocatedAddress);
        if (!manager.hasBreakpoint(BreakpointType.REGULAR, address)) {
            manager.addBreakpoints(BreakpointType.REGULAR, Sets.newHashSet(address));
        }
    }

    public static void toggleBreakpoint(BreakpointManager manager, INaviModule module, UnrelocatedAddress unrelocatedAddress) {
        Preconditions.checkNotNull(manager, "IE01716: Manager argument can not be null");
        Preconditions.checkNotNull(module, "IE01717: Module argument can not be null");
        Preconditions.checkNotNull(unrelocatedAddress, "IE01718: Address argument can not be null");
        BreakpointAddress address = new BreakpointAddress(module, unrelocatedAddress);
        if (manager.hasBreakpoint(BreakpointType.REGULAR, address)) {
            CGraphDebugger.removeBreakpoints(Sets.newHashSet(address), manager);
        } else {
            manager.addBreakpoints(BreakpointType.REGULAR, Sets.newHashSet(address));
        }
    }

    public static void toggleBreakpoint(BackEndDebuggerProvider debuggerProvider, INaviCodeNode codeNode, int row) {
        Preconditions.checkNotNull(debuggerProvider, "IE01719: Debugger provider argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE01720: Code node argument can not be null");
        INaviInstruction instruction = CCodeNodeHelpers.lineToInstruction(codeNode, row);
        if (instruction == null) {
            return;
        }
        IDebugger debugger = CGraphDebugger.getDebugger(debuggerProvider, instruction);
        if (debugger == null) {
            return;
        }
        CGraphDebugger.toggleBreakpoint(debugger.getBreakpointManager(), instruction.getModule(), new UnrelocatedAddress(instruction.getAddress()));
    }

    public static void toggleBreakpoint(BackEndDebuggerProvider debuggerProvider, INaviFunctionNode functionNode) {
        Preconditions.checkNotNull(debuggerProvider, "IE01721: Debugger provider argument can not be null");
        Preconditions.checkNotNull(functionNode, "IE01722: Function node argument can not be null");
        if (functionNode.getFunction().getType() == FunctionType.IMPORT) {
            return;
        }
        IDebugger debugger = CGraphDebugger.getDebugger(debuggerProvider, functionNode);
        if (debugger == null) {
            return;
        }
        INaviModule module = functionNode.getFunction().getModule();
        CGraphDebugger.toggleBreakpoint(debugger.getBreakpointManager(), module, new UnrelocatedAddress(functionNode.getFunction().getAddress()));
    }

    public static void toggleBreakpointStatus(BreakpointManager manager, INaviModule module, UnrelocatedAddress unrelocatedAddress) {
        Preconditions.checkNotNull(manager, "IE01723: Manager argument can not be null");
        Preconditions.checkNotNull(module, "IE01724: Module argument can not be null");
        Preconditions.checkNotNull(unrelocatedAddress, "IE01725: Address argument can not be null");
        BreakpointAddress address = new BreakpointAddress(module, unrelocatedAddress);
        CGraphDebugger.toggleBreakpoint(manager, address);
    }
}

