/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.security.zynamics.binnavi.Gui.CNameShortener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphSaver;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CSaveProgress;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.JGraphTab;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public final class CGraphCloser {
    private CGraphCloser() {
    }

    private static void close(Window parent, List<CGraphPanel> graphs) {
        List<IGraphPanel> modifiedGraphs = CGraphCloser.collectModifiedGraphPanels(graphs);
        if (modifiedGraphs.isEmpty()) {
            CGraphCloser.closeAll(graphs);
        } else {
            int result = CMessageBox.showYesNoCancelQuestion(parent, CGraphCloser.generateMessage(modifiedGraphs));
            if (result == 0) {
                for (IGraphPanel iGraphPanel : modifiedGraphs) {
                    CGraphCloser.saveGraph(parent, iGraphPanel.getModel());
                }
                for (CGraphPanel cGraphPanel : graphs) {
                    cGraphPanel.close(false);
                }
            } else if (result == 1) {
                CGraphCloser.closeAll(graphs);
            } else {
                return;
            }
        }
    }

    private static void closeAll(Iterable<CGraphPanel> panels) {
        for (CGraphPanel panel : panels) {
            panel.close(false);
        }
    }

    private static List<IGraphPanel> collectModifiedGraphPanels(List<CGraphPanel> panels) {
        ArrayList<IGraphPanel> modifiedGraphs = new ArrayList<IGraphPanel>();
        for (CGraphPanel panel : panels) {
            if (!panel.getModel().getGraph().getRawView().wasModified()) continue;
            modifiedGraphs.add(panel);
        }
        return modifiedGraphs;
    }

    private static String generateMessage(List<IGraphPanel> modifiedGraphs) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Save changes to the following graphs?");
        stringBuilder.append('\n');
        for (IGraphPanel panel : modifiedGraphs) {
            String string2 = CNameShortener.shorten(panel.getModel().getGraph().getRawView());
            stringBuilder.append(new StringBuilder(3 + String.valueOf(string2).length()).append("- ").append(string2).append("\n").toString());
        }
        return stringBuilder.toString();
    }

    private static void saveGraph(Window parent, CGraphModel model) {
        if (model.getGraph().getRawView().getType() == ViewType.Native) {
            CGraphCloser.saveNativeGraph(parent, model);
        } else {
            CGraphCloser.saveNonNativeGraph(parent, model);
        }
    }

    private static void saveNativeGraph(Window parent, CGraphModel model) {
        CSaveProgress progress = CGraphSaver.saveAs(parent, model.getGraph(), model.getViewContainer());
        while (!progress.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void saveNonNativeGraph(Window parent, CGraphModel model) {
        CSaveProgress progress = CGraphSaver.save(parent, model.getGraph());
        while (!progress.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void close(CGraphPanel panel) {
        panel.close(true);
    }

    public static void close(JGraphTab graphTab) {
        ArrayList<CGraphPanel> graphs = new ArrayList<CGraphPanel>();
        for (int i2 = 0; i2 < graphTab.getTabCount(); ++i2) {
            graphs.add((CGraphPanel)graphTab.getComponentAt(i2));
        }
        CGraphCloser.close(SwingUtilities.getWindowAncestor(graphTab), graphs);
    }

    public static void closeOthers(JGraphTab graphTab, CGraphPanel panel) {
        ArrayList<CGraphPanel> graphs = new ArrayList<CGraphPanel>();
        for (int i2 = 0; i2 < graphTab.getTabCount(); ++i2) {
            CGraphPanel currentPanel = (CGraphPanel)graphTab.getComponentAt(i2);
            if (currentPanel == panel) continue;
            graphs.add(currentPanel);
        }
        CGraphCloser.close(SwingUtilities.getWindowAncestor(graphTab), graphs);
    }
}

