/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InstructionComments;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.EmptyComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IInstructionCommentAccessor;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeComments;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.List;

public final class LocalInstructionCommentAccessor
implements IInstructionCommentAccessor {
    private final INaviCodeNode m_codeNode;

    public LocalInstructionCommentAccessor(INaviCodeNode codeNode) {
        this.m_codeNode = Preconditions.checkNotNull(codeNode, "IE02696: codeNode argument can not be null");
    }

    @Override
    public List<IComment> appendInstructionComment(INaviInstruction instruction, String commentString) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(instruction, "IE02697: instruction argument can not be null");
        Preconditions.checkNotNull(commentString, "IE02698: comment argument can not be null");
        return this.m_codeNode.getComments().appendLocalInstructionComment(instruction, commentString);
    }

    @Override
    public void deleteInstructionComment(INaviInstruction instruction, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(instruction, "IE02699: instruction argument can not be null");
        Preconditions.checkNotNull(comment, "IE02700: comment argument can not be null");
        this.m_codeNode.getComments().deleteLocalInstructionComment(instruction, comment);
    }

    @Override
    public IComment editInstructionComment(INaviInstruction instruction, IComment comment, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(instruction, "IE02701: instruction argument can not be null");
        Preconditions.checkNotNull(comment, "IE02702: comment argument can not be null");
        return this.m_codeNode.getComments().editLocalInstructionComment(instruction, comment, newComment);
    }

    @Override
    public ArrayList<Pair<INaviInstruction, IComment>> getAllComments() {
        ArrayList<Pair<INaviInstruction, IComment>> values = new ArrayList<Pair<INaviInstruction, IComment>>();
        CCodeNodeComments currentComments = this.m_codeNode.getComments();
        for (INaviInstruction instruction : this.m_codeNode.getInstructions()) {
            List<IComment> comments = currentComments.getLocalInstructionComment(instruction);
            if (comments == null || comments.isEmpty()) {
                values.add(new Pair<INaviInstruction, EmptyComment>(instruction, new EmptyComment()));
                continue;
            }
            for (IComment comment : comments) {
                values.add(new Pair<INaviInstruction, IComment>(instruction, comment));
            }
            values.add(new Pair<INaviInstruction, EmptyComment>(instruction, new EmptyComment()));
        }
        return values;
    }

    @Override
    public List<IComment> getInstructionComments(INaviInstruction instruction) {
        Preconditions.checkNotNull(instruction, "IE02703: instruction argument can not be null");
        return this.m_codeNode.getComments().getLocalInstructionComment(instruction);
    }

    @Override
    public boolean isOwner(IComment comment) {
        Preconditions.checkNotNull(comment, "IE02704: comment argument can not be null");
        return this.m_codeNode.isOwner(comment);
    }
}

