/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InstructionComments;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.helpers.Logger;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CCommentUtilities;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InstructionComments.CGlobalInstructionCommentAccessor;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InstructionComments.LocalInstructionCommentAccessor;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IInstructionCommentAccessor;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.CodeDisplay.BasicCodeDisplayModel;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplay;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayCoordinate;
import com.google.security.zynamics.zylib.gui.CodeDisplay.FormattedCharacterBuffer;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public class InstructionCommentsDataModel
extends BasicCodeDisplayModel {
    private static final BasicCodeDisplayModel.JCodeDisplayColumnDescription[] columns = new BasicCodeDisplayModel.JCodeDisplayColumnDescription[]{new BasicCodeDisplayModel.JCodeDisplayColumnDescription("Instruction", 70, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD), new BasicCodeDisplayModel.JCodeDisplayColumnDescription("Username", 30, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD), new BasicCodeDisplayModel.JCodeDisplayColumnDescription("Comment", 80, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD)};
    private static final int INSTRUCTION_INDEX = 0;
    private static final int USER_INDEX = 1;
    private static final int COMMENT_INDEX = 2;
    final CGraphModel graphModel;
    private final IInstructionCommentAccessor commentAccessor;
    private final CCodeNode node;
    private final List<Pair<INaviInstruction, ArrayList<IComment>>> internalData = new ArrayList<Pair<INaviInstruction, ArrayList<IComment>>>();

    public InstructionCommentsDataModel(CCodeNode codeNode, CGraphModel model, CommentManager.CommentScope scope) {
        Preconditions.checkNotNull(codeNode);
        Preconditions.checkNotNull(model);
        this.commentAccessor = scope == CommentManager.CommentScope.LOCAL ? new LocalInstructionCommentAccessor(codeNode) : new CGlobalInstructionCommentAccessor(codeNode);
        this.graphModel = model;
        this.node = codeNode;
        this.updateDataRepresentation();
    }

    private void updateDataRepresentation() {
        this.internalData.clear();
        for (INaviInstruction instruction : this.node.getInstructions()) {
            this.internalData.add(new Pair(instruction, new ArrayList()));
        }
        int currentIndex = 0;
        for (Pair<INaviInstruction, IComment> dataPair : this.commentAccessor.getAllComments()) {
            while (dataPair.first() != this.internalData.get(currentIndex).first()) {
                ++currentIndex;
            }
            this.internalData.get(currentIndex).second().add(dataPair.second());
        }
    }

    @Override
    public int getNumberOfRows() {
        return this.internalData.size();
    }

    @Override
    public int getTotalNumberOfLines() {
        int totalNumberOfLines = 0;
        for (Pair<INaviInstruction, ArrayList<IComment>> dataPair : this.internalData) {
            for (IComment comment : dataPair.second()) {
                totalNumberOfLines += comment.getNumberOfCommentLines();
            }
        }
        return totalNumberOfLines;
    }

    @Override
    public boolean hasHeaderRow() {
        return true;
    }

    @Override
    public FormattedCharacterBuffer getHeader(int columnIndex) {
        return columns[columnIndex].getHeader();
    }

    @Override
    public int getTotalWidthInCharacters() {
        int total = 0;
        for (int index = 0; index < columns.length; ++index) {
            total += columns[index].getWidth();
        }
        return total;
    }

    @Override
    public int getNumberOfColumns() {
        return columns.length;
    }

    @Override
    public int getColumnWidthInCharacters(int columnIndex) {
        return columns[columnIndex].getWidth();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columns[columnIndex].getName();
    }

    @Override
    public int getMaximumLinesForRow(int rowIndex) {
        int maximumLines = 0;
        for (IComment comment : this.internalData.get(rowIndex).second()) {
            maximumLines += comment.getNumberOfCommentLines() == 0 ? 1 : comment.getNumberOfCommentLines();
        }
        return maximumLines;
    }

    @Override
    public FormattedCharacterBuffer getLineFormatted(int rowIndex, int columnIndex, int lineIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getInstructionCharacterBuffer(rowIndex, columnIndex, lineIndex);
            }
            case 1: {
                return this.getCommentUserCharacterBuffer(rowIndex, columnIndex, lineIndex);
            }
            case 2: {
                return this.getCommentCharacterBuffer(rowIndex, columnIndex, lineIndex);
            }
        }
        Logger.warning("getLineFormatted called with invalid columnIndex, investigate.", new Object[0]);
        return null;
    }

    private IComment getCommentAtCoordinate(CodeDisplayCoordinate coordinate) {
        return this.getCommentAndIndexAtCoordinate(coordinate).first();
    }

    private Pair<IComment, Pair<Integer, Integer>> getCommentAndIndexAtCoordinate(CodeDisplayCoordinate coordinate) {
        ArrayList<IComment> comments = this.internalData.get(coordinate.getRow()).second();
        int currentLineIndex = 0;
        for (IComment comment : comments) {
            int numberOfCommentLines = Math.max(comment.getNumberOfCommentLines(), 1);
            if (currentLineIndex + numberOfCommentLines - 1 >= coordinate.getLine()) {
                if (comment.getNumberOfCommentLines() == 0) {
                    return new Pair<IComment, Pair<Integer, Integer>>(comment, new Pair<Integer, Integer>(0, 0));
                }
                String commentString = comment.getComment();
                int beginIndex = 0;
                int endIndex = 0;
                int targetSubstringIndex = coordinate.getLine() - currentLineIndex;
                int newlineCounter = 0;
                while (newlineCounter != targetSubstringIndex) {
                    if (commentString.charAt(beginIndex++) != '\n') continue;
                    ++newlineCounter;
                }
                endIndex = commentString.indexOf(10, beginIndex);
                endIndex = endIndex == -1 ? commentString.length() : endIndex;
                return new Pair<IComment, Pair<Integer, Integer>>(comment, new Pair<Integer, Integer>(beginIndex, endIndex));
            }
            currentLineIndex += numberOfCommentLines;
        }
        return null;
    }

    private FormattedCharacterBuffer getCommentCharacterBuffer(int rowIndex, int columnIndex, int lineIndex) {
        CodeDisplayCoordinate coordinate = new CodeDisplayCoordinate(rowIndex, lineIndex, columnIndex, 0);
        Pair<IComment, Pair<Integer, Integer>> commentAndIndex = this.getCommentAndIndexAtCoordinate(coordinate);
        String finalComment = "";
        if (commentAndIndex.first().getNumberOfCommentLines() > 0) {
            String commentString = commentAndIndex.first().getComment();
            Pair<Integer, Integer> indices = commentAndIndex.second();
            finalComment = commentString.substring(indices.first(), indices.second());
        }
        finalComment = CodeDisplay.padRight(finalComment, this.getColumnWidthInCharacters(columnIndex));
        return new FormattedCharacterBuffer(finalComment, STANDARD_FONT, columns[2].getDefaultFontColor(), columns[2].getDefaultBackgroundColor());
    }

    private FormattedCharacterBuffer getCommentUserCharacterBuffer(int rowIndex, int columnIndex, int lineIndex) {
        ArrayList<IComment> comments = this.internalData.get(rowIndex).second();
        int currentLineIndex = 0;
        String username = "";
        for (IComment comment : comments) {
            if (currentLineIndex + comment.getNumberOfCommentLines() > lineIndex && currentLineIndex == lineIndex) {
                String temp = comment.getUser().getUserName();
                if (temp == null) break;
                username = temp;
                break;
            }
            currentLineIndex += comment.getNumberOfCommentLines();
        }
        username = CodeDisplay.padRight(username, this.getColumnWidthInCharacters(columnIndex));
        return new FormattedCharacterBuffer(username, STANDARD_FONT, columns[1].getDefaultFontColor(), columns[1].getDefaultBackgroundColor());
    }

    private FormattedCharacterBuffer getInstructionCharacterBuffer(int rowIndex, int columnIndex, int lineIndex) {
        if (lineIndex == 0) {
            String instruction = CCommentUtilities.createInstructionLine(this.internalData.get(rowIndex).first(), this.graphModel);
            instruction = CodeDisplay.padRight(instruction, this.getColumnWidthInCharacters(columnIndex));
            return new FormattedCharacterBuffer(instruction, STANDARD_FONT, columns[0].getDefaultFontColor(), columns[0].getDefaultBackgroundColor());
        }
        String buf = CodeDisplay.padRight("", this.getColumnWidthInCharacters(columnIndex));
        return new FormattedCharacterBuffer(buf, STANDARD_FONT, columns[0].getDefaultFontColor(), columns[0].getDefaultBackgroundColor());
    }

    @Override
    public boolean canHaveCaret(CodeDisplayCoordinate coordinate) {
        return coordinate.getColumn() == 2;
    }

    @Override
    public boolean isEditable(CodeDisplayCoordinate coordinate) {
        if (coordinate.getColumn() == 2) {
            IComment comment = this.getCommentAtCoordinate(coordinate);
            if (comment.getNumberOfCommentLines() == 0) {
                return true;
            }
            if (this.commentAccessor.isOwner(comment)) {
                return true;
            }
        }
        return false;
    }

    private void deleteCharacterFromComment(INaviInstruction instruction, IComment comment, int index) {
        if (comment.getNumberOfCommentLines() == 0) {
            return;
        }
        String oldComment = comment.getComment();
        if (oldComment.length() == index) {
            return;
        }
        String string2 = String.valueOf(oldComment.substring(0, index));
        String string3 = String.valueOf(oldComment.substring(index + 1));
        String newComment = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        try {
            if (newComment.length() == 0) {
                this.commentAccessor.deleteInstructionComment(instruction, comment);
            } else {
                this.commentAccessor.editInstructionComment(instruction, comment, newComment);
            }
        }
        catch (CouldntDeleteException | CouldntSaveDataException e2) {
            Logger.logException(e2);
        }
        this.updateDataRepresentation();
    }

    private void handleBackspaceKeyInComment(INaviInstruction instruction, IComment comment, Pair<Integer, Integer> indices, CodeDisplayCoordinate coordinate) {
        coordinate.setFieldIndex(Math.max(coordinate.getFieldIndex() - 1, 0));
        if (coordinate.getFieldIndex() > indices.second() - indices.first()) {
            return;
        }
        this.deleteCharacterFromComment(instruction, comment, indices.first() + coordinate.getFieldIndex());
    }

    private void handleDeleteKeyInComment(INaviInstruction instruction, IComment comment, Pair<Integer, Integer> indices, CodeDisplayCoordinate coordinate) {
        if (coordinate.getFieldIndex() > indices.second() - indices.first()) {
            return;
        }
        this.deleteCharacterFromComment(instruction, comment, indices.first() + coordinate.getFieldIndex());
    }

    private void handleRegularKeyInComment(INaviInstruction instruction, IComment comment, Pair<Integer, Integer> indices, CodeDisplayCoordinate coordinate, KeyEvent event) {
        if (coordinate.getFieldIndex() > indices.second() - indices.first()) {
            String string2 = String.valueOf(CodeDisplay.padRight("", coordinate.getFieldIndex() - (indices.second() - indices.first())));
            char c2 = event.getKeyChar();
            String newComment = new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append(c2).toString();
            this.insertStringIntoComment(instruction, comment, indices.second(), newComment);
        } else {
            char c3 = event.getKeyChar();
            this.insertStringIntoComment(instruction, comment, indices.first() + coordinate.getFieldIndex(), new StringBuilder(1).append(c3).toString());
        }
    }

    private void insertStringIntoComment(INaviInstruction instruction, IComment comment, int index, String string2) {
        if (comment.getNumberOfCommentLines() == 0) {
            String newComment = CodeDisplay.padRight("", index);
            String string3 = String.valueOf(newComment);
            String string4 = String.valueOf(string2);
            newComment = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            try {
                this.commentAccessor.appendInstructionComment(instruction, newComment);
            }
            catch (CouldntLoadDataException | CouldntSaveDataException e2) {
                Logger.logException(e2);
            }
        } else {
            String oldComment = comment.getComment();
            String string5 = String.valueOf(oldComment.substring(0, index));
            String string6 = String.valueOf(oldComment.substring(index));
            String newComment = new StringBuilder(0 + String.valueOf(string5).length() + String.valueOf(string2).length() + String.valueOf(string6).length()).append(string5).append(string2).append(string6).toString();
            try {
                this.commentAccessor.editInstructionComment(instruction, comment, newComment);
            }
            catch (CouldntSaveDataException e3) {
                Logger.logException(e3);
            }
        }
        this.updateDataRepresentation();
    }

    @Override
    public void keyPressedOrTyped(CodeDisplayCoordinate coordinate, KeyEvent event) {
        if (!this.isEditable(coordinate)) {
            return;
        }
        INaviInstruction instruction = this.internalData.get(coordinate.getRow()).first();
        Pair<IComment, Pair<Integer, Integer>> commentAndIndex = this.getCommentAndIndexAtCoordinate(coordinate);
        IComment comment = commentAndIndex.first();
        Pair<Integer, Integer> indices = commentAndIndex.second();
        block0 : switch (event.getKeyCode()) {
            case 0: {
                switch (event.getKeyChar()) {
                    case '\n': {
                        this.handleRegularKeyInComment(instruction, comment, indices, coordinate, event);
                        coordinate.setLine(coordinate.getLine() + 1);
                        coordinate.setFieldIndex(0);
                        break block0;
                    }
                    case '\b': {
                        this.handleBackspaceKeyInComment(instruction, comment, indices, coordinate);
                        break block0;
                    }
                    case '\u007f': {
                        this.handleDeleteKeyInComment(instruction, comment, indices, coordinate);
                        break block0;
                    }
                }
                this.handleRegularKeyInComment(instruction, comment, indices, coordinate, event);
                coordinate.setFieldIndex(coordinate.getFieldIndex() + 1);
                break;
            }
            case 36: {
                coordinate.setFieldIndex(0);
                break;
            }
            case 35: {
                coordinate.setFieldIndex(indices.second() - indices.first());
                break;
            }
            default: {
                Logger.warning("Default case in keyTyped hit, investigate why.", new Object[0]);
            }
        }
    }
}

