/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InstructionComments;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.EmptyComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IInstructionCommentAccessor;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.List;

public final class CGlobalInstructionCommentAccessor
implements IInstructionCommentAccessor {
    private final INaviCodeNode m_codeNode;

    public CGlobalInstructionCommentAccessor(INaviCodeNode codeNode) {
        this.m_codeNode = Preconditions.checkNotNull(codeNode, "IE02684: codenode argument can not be null");
    }

    @Override
    public List<IComment> appendInstructionComment(INaviInstruction instruction, String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(instruction, "IE02685: instruction argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02686: comment argument can not be null");
        return instruction.appendGlobalComment(commentText);
    }

    @Override
    public void deleteInstructionComment(INaviInstruction instruction, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(instruction, "IE02687: instruction argument can not be null");
        Preconditions.checkNotNull(comment, "IE02688: comment argument can not be null");
        instruction.deleteGlobalComment(comment);
    }

    @Override
    public IComment editInstructionComment(INaviInstruction instruction, IComment comment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(instruction, "IE02689: instruction argument can not be null");
        Preconditions.checkNotNull(comment, "IE02690: comment argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02691: commentText argument can not be null");
        return instruction.editGlobalComment(comment, commentText);
    }

    @Override
    public ArrayList<Pair<INaviInstruction, IComment>> getAllComments() {
        ArrayList<Pair<INaviInstruction, IComment>> values = new ArrayList<Pair<INaviInstruction, IComment>>();
        for (INaviInstruction instruction : this.m_codeNode.getInstructions()) {
            List<IComment> comments = instruction.getGlobalComment();
            if (comments == null || comments.isEmpty()) {
                values.add(new Pair<INaviInstruction, EmptyComment>(instruction, new EmptyComment()));
                continue;
            }
            for (IComment comment : comments) {
                values.add(new Pair<INaviInstruction, IComment>(instruction, comment));
            }
            values.add(new Pair<INaviInstruction, EmptyComment>(instruction, new EmptyComment()));
        }
        return values;
    }

    @Override
    public List<IComment> getInstructionComments(INaviInstruction instruction) {
        return instruction.getGlobalComment();
    }

    @Override
    public boolean isOwner(IComment comment) {
        return this.m_codeNode.isOwner(comment);
    }
}

