/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.EdgeComments;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.ICommentAccessor;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import java.util.List;

public class CLocalEdgeCommentAccessor
implements ICommentAccessor {
    private final INaviEdge m_edge;

    public CLocalEdgeCommentAccessor(INaviEdge edge) {
        this.m_edge = Preconditions.checkNotNull(edge, "IE02659: edge argument can not be null");
    }

    @Override
    public List<IComment> appendComment(String newComment) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(newComment, "IE02660: newComment argument can not be null");
        return this.m_edge.appendLocalComment(newComment);
    }

    @Override
    public void deleteComment(IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(comment, "IE02661: comment argument can not be null");
        this.m_edge.deleteLocalComment(comment);
    }

    @Override
    public IComment editComment(IComment comment, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(comment, "IE02662: comment argument can not be null");
        Preconditions.checkNotNull(newComment, "IE02663: newComment argument can not be null");
        return this.m_edge.editLocalComment(comment, newComment);
    }

    @Override
    public List<IComment> getComment() {
        return this.m_edge.getLocalComment();
    }

    @Override
    public boolean isOwner(IComment comment) {
        Preconditions.checkNotNull(comment, "IE02664: comment argument can not be null");
        return this.m_edge.isOwner(comment);
    }
}

