/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.EdgeComments;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.Quad;
import java.util.ArrayList;
import java.util.List;

public final class CGlobalEdgeCommentSynchronizer {
    private CGlobalEdgeCommentSynchronizer() {
    }

    private static List<INaviEdge> collectEdges(INaviView view, Quad<Integer, IAddress, Integer, IAddress> refEdgeData) throws MaybeNullException {
        ArrayList<INaviEdge> edgelist = new ArrayList<INaviEdge>();
        if (view.isLoaded()) {
            for (INaviEdge otherEdge : view.getGraph().getEdges()) {
                Quad<Integer, IAddress, Integer, IAddress> edgeData = CGlobalEdgeCommentSynchronizer.getEdgeData(otherEdge);
                if (!CGlobalEdgeCommentSynchronizer.isEdgeDataValid(edgeData) || !edgeData.equals(refEdgeData)) continue;
                edgelist.add(otherEdge);
            }
        }
        return edgelist;
    }

    private static Quad<Integer, IAddress, Integer, IAddress> getEdgeData(INaviEdge edge) throws MaybeNullException {
        IAddress srcAddr = null;
        IAddress dstAddr = null;
        int srcModuleId = -1;
        int dstModuleId = -1;
        if (edge.getSource() instanceof INaviCodeNode) {
            srcAddr = ((INaviCodeNode)edge.getSource()).getAddress();
            srcModuleId = ((INaviCodeNode)edge.getSource()).getParentFunction().getModule().getConfiguration().getId();
        } else if (edge.getSource() instanceof INaviFunctionNode) {
            srcAddr = ((INaviFunctionNode)edge.getSource()).getFunction().getAddress();
            srcModuleId = ((INaviFunctionNode)edge.getSource()).getFunction().getModule().getConfiguration().getId();
        }
        if (edge.getTarget() instanceof INaviCodeNode) {
            dstAddr = ((INaviCodeNode)edge.getTarget()).getAddress();
            dstModuleId = ((INaviCodeNode)edge.getTarget()).getParentFunction().getModule().getConfiguration().getId();
        } else if (edge.getTarget() instanceof INaviFunctionNode) {
            dstAddr = ((INaviFunctionNode)edge.getTarget()).getFunction().getAddress();
            dstModuleId = ((INaviFunctionNode)edge.getTarget()).getFunction().getModule().getConfiguration().getId();
        }
        return new Quad<Integer, IAddress, Integer, IAddress>(srcModuleId, srcAddr, dstModuleId, dstAddr);
    }

    private static Pair<INaviModule, INaviModule> getModules(INaviEdge edge) throws MaybeNullException {
        INaviModule srcModule = null;
        INaviModule tarModule = null;
        if (edge.getSource() instanceof INaviCodeNode) {
            srcModule = ((INaviCodeNode)edge.getSource()).getParentFunction().getModule();
        } else if (edge.getSource() instanceof INaviFunctionNode) {
            srcModule = ((INaviFunctionNode)edge.getSource()).getFunction().getModule();
        }
        if (edge.getTarget() instanceof INaviCodeNode) {
            tarModule = ((INaviCodeNode)edge.getTarget()).getParentFunction().getModule();
        } else if (edge.getTarget() instanceof INaviFunctionNode) {
            tarModule = ((INaviFunctionNode)edge.getTarget()).getFunction().getModule();
        }
        return new Pair<INaviModule, INaviModule>(srcModule, tarModule);
    }

    private static boolean isEdgeDataValid(Quad<Integer, IAddress, Integer, IAddress> edgeData) {
        if (edgeData.second() == null || edgeData.fourth() == null) {
            return false;
        }
        return edgeData.first() != -1 && edgeData.third() != -1;
    }

    public static void updateOpenViews(INaviEdge edge, ArrayList<IComment> comments) throws CouldntSaveDataException {
        try {
            Pair<INaviModule, INaviModule> modules = CGlobalEdgeCommentSynchronizer.getModules(edge);
            if (modules.first() != modules.second()) {
                return;
            }
            if (modules.first() != null && modules.second() != null && modules.first().isLoaded()) {
                ArrayList<INaviEdge> edgelist = new ArrayList<INaviEdge>();
                Quad<Integer, IAddress, Integer, IAddress> refEdgeData = CGlobalEdgeCommentSynchronizer.getEdgeData(edge);
                for (INaviView view : modules.first().getContent().getViewContainer().getViews()) {
                    edgelist.addAll(CGlobalEdgeCommentSynchronizer.collectEdges(view, refEdgeData));
                }
                for (INaviEdge updateEdge : edgelist) {
                    updateEdge.initializeGlobalComment(comments);
                }
            }
        }
        catch (MaybeNullException maybeNullException) {
            // empty catch block
        }
    }
}

