/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.CIconInitializer;
import com.google.security.zynamics.binnavi.Gui.CNameShortener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CWindowCloser;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CWindowTitle;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.GraphIterator;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphContainerWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphWindowListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphCloser;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.JGraphTab;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.JGraphTabMenu;
import com.google.security.zynamics.binnavi.Gui.Progress.CProgressStatusBar;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviGraphListenerAdapter;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class CGraphWindow
extends JFrame
implements IGraphContainerWindow {
    private static final long serialVersionUID = 3265629894301476389L;
    private final JGraphTab m_tabbedPane = new JGraphTab(this);
    private final ListenerProvider<IGraphWindowListener> m_graphPanelListener = new ListenerProvider();
    private final InternalViewListener m_viewListener = new InternalViewListener();
    private final InternalGraphListener m_graphListener = new InternalGraphListener();

    public CGraphWindow() {
        CIconInitializer.initializeWindowIcons(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CWindowCloser(this.m_tabbedPane));
        InternalTabListener listener = new InternalTabListener();
        this.m_tabbedPane.getModel().addChangeListener(listener);
        this.m_tabbedPane.addContainerListener(listener);
        this.addWindowStateListener(new WorkaroundListener());
        this.m_tabbedPane.addMouseListener(new InternalMouseListener());
        this.add(this.m_tabbedPane);
        JPanel statusBar = new JPanel(new BorderLayout());
        statusBar.add((Component)new CProgressStatusBar(), "East");
        this.add((Component)statusBar, "South");
    }

    private boolean alreadyListening(INaviView view) {
        return this.viewOpenCount(view) > 0;
    }

    private IGraphPanel getActiveGraphWindow() {
        return (IGraphPanel)((Object)this.m_tabbedPane.getSelectedComponent());
    }

    private void updateCurrentWindowTitle(INaviView view) {
        IGraphPanel window = this.getActiveGraphWindow();
        if (window == null) {
            return;
        }
        INaviView currentView = window.getModel().getGraph().getRawView();
        if (view == currentView) {
            this.setTitle(CWindowTitle.generate(window));
        }
    }

    private void updateWindow() {
        IGraphPanel window = this.getActiveGraphWindow();
        if (window == null) {
            return;
        }
        this.setTitle(CWindowTitle.generate(window));
        this.setJMenuBar(window.getMenu());
    }

    private int viewOpenCount(INaviView view) {
        int counter = 0;
        for (int i2 = 0; i2 < this.getOpenGraphCount(); ++i2) {
            IGraphPanel component = (IGraphPanel)((Object)this.m_tabbedPane.getComponentAt(i2));
            if (view != component.getModel().getGraph().getRawView()) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public void activate(IGraphPanel panel) {
        this.m_tabbedPane.setSelectedComponent(panel.getPanel());
    }

    @Override
    public void addGraph(IGraphPanel panel) {
        if (panel.getPanel() == null) {
            throw new IllegalStateException("IE01145: Invalid panel object returned");
        }
        ZyGraph graph = panel.getModel().getGraph();
        graph.addListener(this.m_graphListener);
        INaviView rawView = graph.getRawView();
        if (!this.alreadyListening(rawView)) {
            rawView.addListener(this.m_viewListener);
        }
        this.m_tabbedPane.addTab(CNameShortener.shorten(rawView), panel.getPanel());
    }

    @Override
    public void addListener(IGraphWindowListener listener) {
        this.m_graphPanelListener.addListener(listener);
    }

    public boolean close() {
        CGraphCloser.close(this.m_tabbedPane);
        return this.m_tabbedPane.getTabCount() == 0;
    }

    @Override
    public void close(IGraphPanel panel) {
        Preconditions.checkNotNull(panel, "IE01625: Panel argument can't be null");
        if (this.m_tabbedPane.indexOfComponent(panel.getPanel()) == -1) {
            throw new IllegalStateException("IE01146: Panel argument does not belong to the tab");
        }
        this.m_tabbedPane.remove(panel.getPanel());
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    @Override
    public int getOpenGraphCount() {
        return this.m_tabbedPane.getTabCount();
    }

    public boolean isActiveGraph(IGraphPanel panel) {
        return this.m_tabbedPane.getSelectedComponent() == panel.getPanel();
    }

    @Override
    public Iterator<IGraphPanel> iterator() {
        return new GraphIterator(this.m_tabbedPane);
    }

    @Override
    public void removeListener(IGraphWindowListener listener) {
        this.m_graphPanelListener.removeListener(listener);
    }

    private class WorkaroundListener
    implements WindowStateListener {
        private boolean firstShrinking = true;

        private WorkaroundListener() {
        }

        @Override
        public void windowStateChanged(WindowEvent event) {
            if (this.firstShrinking && event.getNewState() == 0) {
                CGraphWindow.this.setSize((int)((double)CGraphWindow.this.getWidth() * 0.75), (int)((double)CGraphWindow.this.getHeight() * 0.75));
                this.firstShrinking = false;
            }
        }
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        @Override
        public void changedDescription(INaviView view, String description) {
            CGraphWindow.this.updateCurrentWindowTitle(view);
        }

        @Override
        public void changedName(INaviView view, String name) {
            CGraphWindow.this.updateCurrentWindowTitle(view);
            CGraphWindow.this.m_tabbedPane.updateRegisterHeaders();
        }
    }

    private class InternalTabListener
    implements ChangeListener,
    ContainerListener {
        private InternalTabListener() {
        }

        private void closeWindow() {
            CGraphWindow.this.setJMenuBar(null);
            CGraphWindow.this.setVisible(false);
            CGraphWindow.this.dispose();
        }

        @Override
        public void componentAdded(ContainerEvent event) {
            for (IGraphWindowListener listener : CGraphWindow.this.m_graphPanelListener) {
                try {
                    listener.graphPanelOpened((CGraphPanel)event.getChild());
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void componentRemoved(ContainerEvent event) {
            IGraphPanel removedPanel = (IGraphPanel)((Object)event.getChild());
            ZyGraph graph = removedPanel.getModel().getGraph();
            graph.removeListener(CGraphWindow.this.m_graphListener);
            removedPanel.dispose();
            if (CGraphWindow.this.viewOpenCount(graph.getRawView()) == 0) {
                graph.getRawView().removeListener(CGraphWindow.this.m_viewListener);
            }
            if (CGraphWindow.this.m_tabbedPane.getTabCount() == 0) {
                this.closeWindow();
            } else {
                CGraphWindow.this.updateWindow();
            }
            for (IGraphWindowListener listener : CGraphWindow.this.m_graphPanelListener) {
                try {
                    listener.graphPanelClosed();
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
            if (CGraphWindow.this.m_tabbedPane.getTabCount() == 0) {
                this.closeWindow();
            }
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            CGraphWindow.this.updateWindow();
            int index = CGraphWindow.this.m_tabbedPane.getSelectedIndex();
            for (int i2 = 0; i2 < CGraphWindow.this.m_tabbedPane.getTabCount(); ++i2) {
                CGraphPanel panel = (CGraphPanel)CGraphWindow.this.m_tabbedPane.getComponentAt(i2);
                panel.getToolbar().getSearchPanel().showResultsDialog(i2 == index);
            }
        }
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        private void showPopupMenu(MouseEvent event) {
            int index = CGraphWindow.this.m_tabbedPane.indexAtLocation(event.getX(), event.getY());
            if (index == -1) {
                return;
            }
            CGraphPanel child = (CGraphPanel)CGraphWindow.this.m_tabbedPane.getComponentAt(index);
            JGraphTabMenu menu = new JGraphTabMenu(CGraphWindow.this.m_tabbedPane, child);
            menu.show(event.getComponent(), event.getX(), event.getY());
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }
    }

    private class InternalGraphListener
    extends NaviGraphListenerAdapter {
        private InternalGraphListener() {
        }

        @Override
        public void changedView(INaviView oldView, INaviView newView) {
            if (CGraphWindow.this.viewOpenCount(oldView) == 0) {
                oldView.removeListener(CGraphWindow.this.m_viewListener);
            }
            newView.addListener(CGraphWindow.this.m_viewListener);
            CGraphWindow.this.m_tabbedPane.updateRegisterHeaders();
            CGraphWindow.this.updateCurrentWindowTitle(newView);
        }
    }
}

