/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.ButtonTab;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.ButtonTab.IButtonTabListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public final class ButtonTabComponent
extends JPanel {
    private static final long serialVersionUID = -6626650103082832554L;
    private static final Color ROLL_OVER_COLOR = new Color(160, 0, 0);
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent event) {
            Component component = event.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            Component component = event.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };
    private final ListenerProvider<IButtonTabListener> m_listeners = new ListenerProvider();
    private final JTabbedPane m_pane;

    public ButtonTabComponent(final JTabbedPane pane) {
        super(new FlowLayout(0, 0, 0));
        this.m_pane = Preconditions.checkNotNull(pane, "IE01213: TabbedPane is null");
        this.setOpaque(false);
        JLabel label = new JLabel(){
            private static final long serialVersionUID = 8139543899934835869L;

            @Override
            public String getText() {
                int index = pane.indexOfTabComponent(ButtonTabComponent.this);
                if (index != -1) {
                    return pane.getTitleAt(index);
                }
                return null;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton button = new TabButton();
        this.add(button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    public void addListener(IButtonTabListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void removeListener(IButtonTabListener listener) {
        this.m_listeners.removeListener(listener);
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 5815406628571547063L;

        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(17, 17));
            this.setToolTipText("Close this tab.");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2d = (Graphics2D)graphics.create();
            graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.getModel().isPressed()) {
                graphics2d.translate(1, 1);
            }
            graphics2d.setStroke(new BasicStroke(3.0f));
            graphics2d.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                graphics2d.setColor(ROLL_OVER_COLOR);
            }
            int delta = 6;
            graphics2d.drawLine(6, 6, this.getWidth() - 6 - 1, this.getHeight() - 6 - 1);
            graphics2d.drawLine(this.getWidth() - 6 - 1, 6, 6, this.getHeight() - 6 - 1);
            graphics2d.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int index = ButtonTabComponent.this.m_pane.indexOfTabComponent(ButtonTabComponent.this);
            if (index != -1) {
                for (IButtonTabListener listener : ButtonTabComponent.this.m_listeners) {
                    try {
                        if (listener.closing(ButtonTabComponent.this)) continue;
                        return;
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
                ButtonTabComponent.this.m_pane.remove(index);
            }
        }

        @Override
        public void updateUI() {
        }
    }
}

