/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.viewReferences;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeSystemIcons;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.CDefaultModifier;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyInstructionBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.ModuleTargetSettings;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.gui.jtree.IconNode;
import javax.swing.Icon;

public class InstructionNode
extends IconNode {
    private final INaviInstruction instruction;

    public InstructionNode(INaviInstruction instruction, boolean isLocal) {
        this.instruction = Preconditions.checkNotNull(instruction, "Error: instruction argument can not be null.");
        this.setIcon(this.determineIcon(isLocal));
    }

    private Icon determineIcon(boolean isLocal) {
        return isLocal ? TypeSystemIcons.LOCAL_VARIABLE_ICON : TypeSystemIcons.GLOBAL_VARIABLE_ICON;
    }

    public INaviInstruction getInstruction() {
        return this.instruction;
    }

    @Override
    public String toString() {
        ZyGraphViewSettings settings = new ZyGraphViewSettings(new GraphSettingsConfigItem());
        DebuggerProvider provider = new DebuggerProvider(new ModuleTargetSettings(this.instruction.getModule()));
        return ZyInstructionBuilder.buildInstructionLine(this.instruction, settings, new CDefaultModifier(settings, provider)).first();
    }
}

