/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.viewReferences;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.viewReferences.CVariableHighlighter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.viewReferences.InstructionNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.viewReferences.ViewReferencesTable;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.viewReferences.ViewReferencesTableModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.IGraphPanelExtension;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanelExtender;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.BaseTypeTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeMemberTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions.EditMemberAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions.EditTypeAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.EditTypeInstanceAction;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CodeNode.TypeSubstitutionAction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.gui.jtree.IconNode;
import com.google.security.zynamics.zylib.gui.jtree.TreeHelpers;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class CVariablesPanel
extends JPanel
implements IGraphPanelExtension {
    private CGraphModel graphModel;
    private ViewReferencesTable referencesTable;
    private final TreeSelectionListener treeSelectionListener = new InternalTreeSelectionListener();

    public CVariablesPanel() {
        super(new BorderLayout());
    }

    private TypeManager getTypeManager() {
        return this.graphModel.getGraph().getRawView().getConfiguration().getModule().getTypeManager();
    }

    private TypeInstanceContainer getTypeInstanceContainer() {
        return this.graphModel.getGraph().getRawView().getConfiguration().getModule().getContent().getTypeInstanceContainer();
    }

    private JPopupMenu createPopupMenu(IconNode selectedNode) {
        JPopupMenu menu = new JPopupMenu();
        if (selectedNode instanceof TypeMemberTreeNode) {
            menu.add(new EditMemberAction(this.graphModel.getParent(), this.getTypeManager(), ((TypeMemberTreeNode)selectedNode).getTypeMember()));
            return menu;
        }
        if (selectedNode instanceof BaseTypeTreeNode) {
            menu.add(new EditTypeAction(this.graphModel.getParent(), this.getTypeManager(), ((BaseTypeTreeNode)selectedNode).getBaseType()));
            return menu;
        }
        if (selectedNode instanceof InstructionNode) {
            ViewReferencesTableModel model = (ViewReferencesTableModel)this.referencesTable.getModel();
            if (model.getTypeInstanceReference((InstructionNode)selectedNode) != null) {
                menu.add(new EditTypeInstanceAction(this.graphModel.getParent(), this.getTypeManager(), model.getTypeInstanceReference((InstructionNode)selectedNode).getTypeInstance(), this.getTypeInstanceContainer()));
            }
            if (model.getTypeSubstitution((InstructionNode)selectedNode) != null) {
                try {
                    menu.add(TypeSubstitutionAction.instantiateEditTypeSubstitution(this.graphModel.getParent(), this.getTypeManager(), this.graphModel.getGraph().getRawView().getConfiguration().getModule().getContent().getFunctionContainer().getFunction(this.graphModel.getGraph().getRawView().getConfiguration().getName()).getStackFrame(), model.getTypeSubstitution((InstructionNode)selectedNode).getOperandTreeNode()));
                }
                catch (MaybeNullException exception) {
                    exception.printStackTrace();
                }
            }
            return menu;
        }
        return null;
    }

    private void showPopupMenu(MouseEvent event) {
        JPopupMenu menu;
        IconNode selectedNode = (IconNode)TreeHelpers.getNodeAt(this.referencesTable, event.getX(), event.getY());
        if (selectedNode != null && (menu = this.createPopupMenu(selectedNode)) != null) {
            menu.show(this.referencesTable, event.getX(), event.getY());
        }
    }

    @Override
    public void dispose() {
        if (this.referencesTable != null) {
            this.referencesTable.dispose();
        }
    }

    @Override
    public void visit(CGraphModel model, IGraphPanelExtender extender) {
        this.graphModel = model;
        if (this.graphModel.getGraph().getRawView().getConfiguration().getModule() == null) {
            return;
        }
        extender.addTab("Variables", this);
        ViewReferencesTableModel treeModel = new ViewReferencesTableModel(model.getGraph().getRawView());
        this.referencesTable = new ViewReferencesTable(treeModel);
        this.add(new JScrollPane(this.referencesTable));
        this.referencesTable.addTreeSelectionListener(this.treeSelectionListener);
        this.referencesTable.addMouseListener(new VariablesPanelMouseAdapter());
    }

    private class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        private Set<INaviInstruction> getSelectedVariables(TreePath[] paths) {
            HashSet<INaviInstruction> instructions = Sets.newHashSet();
            if (paths == null) {
                return instructions;
            }
            for (TreePath treePath : paths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (node instanceof InstructionNode) {
                    instructions.add(((InstructionNode)node).getInstruction());
                    continue;
                }
                instructions.addAll(this.findInstructions(node));
            }
            return instructions;
        }

        private Set<INaviInstruction> findInstructions(DefaultMutableTreeNode node) {
            HashSet<INaviInstruction> instructions = Sets.newHashSet();
            Enumeration<TreeNode> enumeration = node.preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!currentNode.isLeaf() || !(currentNode instanceof InstructionNode)) continue;
                instructions.add(((InstructionNode)currentNode).getInstruction());
            }
            return instructions;
        }

        private void handleSingleNodeSelection(TreePath[] paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            if (node instanceof InstructionNode) {
                CVariableHighlighter.highlightInstructions(CVariablesPanel.this.graphModel.getGraph(), Lists.newArrayList(((InstructionNode)node).getInstruction()));
                return;
            }
            if (node instanceof BaseTypeTreeNode || node instanceof TypeMemberTreeNode) {
                CVariableHighlighter.highlightInstructions(CVariablesPanel.this.graphModel.getGraph(), this.findInstructions(node));
                return;
            }
        }

        private void handleMultipleNodeSelection(TreePath[] paths) {
            CVariableHighlighter.highlightInstructions(CVariablesPanel.this.graphModel.getGraph(), this.getSelectedVariables(paths));
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath[] paths = CVariablesPanel.this.referencesTable.getSelectionPaths();
            if (paths != null && paths.length == 1) {
                this.handleSingleNodeSelection(paths);
            } else {
                this.handleMultipleNodeSelection(paths);
            }
        }
    }

    private class VariablesPanelMouseAdapter
    extends MouseAdapter {
        private VariablesPanelMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Object node = CVariablesPanel.this.referencesTable.getLastSelectedPathComponent();
            if (node instanceof InstructionNode) {
                InstructionNode vnode = (InstructionNode)node;
                ZyZoomHelpers.zoomToInstruction(CVariablesPanel.this.graphModel.getGraph(), vnode.getInstruction());
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CVariablesPanel.this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CVariablesPanel.this.showPopupMenu(event);
            }
        }
    }
}

