/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CInstructionResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResultContainer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResultsHighlighter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CViewPruner;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanelExtender;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;

public final class CTrackingResultsToolbar
extends JToolBar {
    private static final long serialVersionUID = -3912462323753347468L;
    private final IGraphPanelExtender m_extender;
    private final CTrackingResultContainer m_container;

    public CTrackingResultsToolbar(IGraphPanelExtender extender, CTrackingResultContainer container) {
        this.m_container = Preconditions.checkNotNull(container, "IE02305: container argument can not be null");
        this.m_extender = Preconditions.checkNotNull(extender, "IE02306: extender argument can not be null");
        this.setFloatable(false);
        CTrackingResultsToolbar.createAndAddIconToToolbar(this, new ClearAction(), "data/clearinstructionhighlighting_up.png", "data/clearinstructionhighlighting_hover.png", "data/clearinstructionhighlighting_down.png");
        CTrackingResultsToolbar.createAndAddIconToToolbar(this, new CloneAction(), "data/createnewgraph_up.png", "data/createnewgraph_hover.png", "data/createnewgraph_down.png");
    }

    private static JButton createAndAddIconToToolbar(JToolBar toolBar, AbstractAction action, String defaultIconPath, String rolloverIconPath, String pressedIconPath) {
        JButton button = toolBar.add(CActionProxy.proxy(action));
        button.setBorder(new EmptyBorder(0, 0, 0, 0));
        button.setIcon(new ImageIcon(CMain.class.getResource(defaultIconPath)));
        button.setRolloverIcon(new ImageIcon(CMain.class.getResource(rolloverIconPath)));
        button.setPressedIcon(new ImageIcon(CMain.class.getResource(pressedIconPath)));
        return button;
    }

    private class CloneAction
    extends AbstractAction {
        private static final long serialVersionUID = 2088458708261529407L;

        private CloneAction() {
            this.putValue("ShortDescription", "Create a new graph with only register tracking results");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTrackingResult result = CTrackingResultsToolbar.this.m_container.getResult();
            if (result == null) {
                return;
            }
            ArrayList<INaviInstruction> keptInstructions = new ArrayList<INaviInstruction>();
            for (CInstructionResult instructionResult : result.getResults()) {
                if (instructionResult.getInstruction() != result.getStartInstruction() && !instructionResult.uses() && !instructionResult.undefinesAll()) continue;
                keptInstructions.add(instructionResult.getInstruction());
            }
            INaviView view = CViewPruner.prune(CTrackingResultsToolbar.this.m_container.getViewContainer(), CTrackingResultsToolbar.this.m_container.getGraph().getRawView(), keptInstructions);
            CTrackingResultsToolbar.this.m_extender.openView(CTrackingResultsToolbar.this.m_container.getViewContainer(), view);
        }
    }

    private class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = -2927736768691304058L;

        private ClearAction() {
            this.putValue("ShortDescription", "Remove results highlighting from the graph");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTrackingResult result = CTrackingResultsToolbar.this.m_container.getResult();
            if (result == null) {
                return;
            }
            CTrackingResultsHighlighter.updateHighlighting(CTrackingResultsToolbar.this.m_container.getGraph(), result.getStartInstruction(), "", new ArrayList<CInstructionResult>());
        }
    }
}

