/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CInstructionResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CResultColor;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import java.util.List;

public final class CTrackingResultsHighlighter {
    private CTrackingResultsHighlighter() {
    }

    private static void clearHighlighting(ZyGraph graph) {
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                if (node.getRawNode() instanceof INaviCodeNode) {
                    INaviCodeNode cnode = (INaviCodeNode)node.getRawNode();
                    for (INaviInstruction instruction : cnode.getInstructions()) {
                        int line = CCodeNodeHelpers.instructionToLine(cnode, instruction);
                        node.clearHighlighting(800, line);
                    }
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    private static void highlightCodeNode(INaviCodeNode cnode, INaviInstruction startInstruction, String trackedRegister, CInstructionResult instructionResult) {
        INaviInstruction searchInstruction = instructionResult.getInstruction();
        if (!CCodeNodeHelpers.containsAddress(cnode, searchInstruction.getAddress())) {
            return;
        }
        for (INaviInstruction instruction : cnode.getInstructions()) {
            if (searchInstruction != instruction) continue;
            cnode.setInstructionColor(instruction, 800, CResultColor.determineBackgroundColor(startInstruction, trackedRegister, instructionResult));
        }
    }

    private static void highlightInstructions(ZyGraph graph, final INaviInstruction startInstruction, final String trackedRegister, List<CInstructionResult> instructionResults) {
        for (final CInstructionResult instructionResult : instructionResults) {
            graph.iterate(new INodeCallback<NaviNode>(){

                @Override
                public IterationMode next(NaviNode node) {
                    if (node.getRawNode() instanceof INaviCodeNode) {
                        INaviCodeNode cnode = (INaviCodeNode)node.getRawNode();
                        CTrackingResultsHighlighter.highlightCodeNode(cnode, startInstruction, trackedRegister, instructionResult);
                    }
                    return IterationMode.CONTINUE;
                }
            });
        }
    }

    public static void updateHighlighting(ZyGraph graph, INaviInstruction startInstruction, String trackedRegister, List<CInstructionResult> instructionResults) {
        Preconditions.checkNotNull(graph, "IE01529: Graph argument can not be null");
        Preconditions.checkNotNull(startInstruction, "IE01687: Start instruction argument can not be null");
        Preconditions.checkNotNull(trackedRegister, "IE01688: Tracked register argument can not be null");
        Preconditions.checkNotNull(instructionResults, "IE01540: Instruction results argument can not be null");
        CTrackingResultsHighlighter.clearHighlighting(graph);
        CTrackingResultsHighlighter.highlightInstructions(graph, startInstruction, trackedRegister, instructionResults);
    }
}

