/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTracking;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResultContainer;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.algorithms.mono2.common.enums.AnalysisDirection;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterTrackingOptions;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public final class CTrackOperandAction
extends AbstractAction {
    private static final long serialVersionUID = 7794473006806206907L;
    private final CTrackingResultContainer m_resultsContainer;
    private final INaviInstruction m_instruction;
    private final String m_register;
    private final RegisterTrackingOptions m_options;

    public CTrackOperandAction(CTrackingResultContainer resultsContainer, INaviInstruction instruction, String register2, RegisterTrackingOptions options) {
        super(CTrackOperandAction.generateName(options));
        this.m_resultsContainer = Preconditions.checkNotNull(resultsContainer, "IE01696: Container argument can not be null");
        this.m_instruction = Preconditions.checkNotNull(instruction, "IE01697: Instruction argument can not be null");
        this.m_register = Preconditions.checkNotNull(register2, "IE01698: Register argument can not be null");
        this.m_options = Preconditions.checkNotNull(options, "IE02307: options argument can not be null");
    }

    private static String generateName(RegisterTrackingOptions options) {
        return options.getAnalysisDirection() == AnalysisDirection.DOWN ? "Track Operand Forward" : "Track Operand Backward";
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            CTrackingResult result = CTracking.track(this.m_resultsContainer.getGraph().getRawView(), this.m_instruction, this.m_register, this.m_options);
            this.m_resultsContainer.setResult(result);
        }
        catch (InternalTranslationException e2) {
            CUtilityFunctions.logException(e2);
        }
    }
}

