/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CInstructionResult;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;

public final class CResultColumnWrapper
implements Comparable<CResultColumnWrapper> {
    private final String m_trackedRegister;
    private final CInstructionResult m_instructionResult;
    private final INaviInstruction m_startInstruction;

    public CResultColumnWrapper(INaviInstruction startInstruction, String trackedRegister, CInstructionResult instructionResult) {
        Preconditions.checkNotNull(startInstruction, "IE01677: Start instruction argument can not be null");
        Preconditions.checkNotNull(trackedRegister, "IE01678: Tracked register argument can not be null");
        Preconditions.checkNotNull(instructionResult, "IE01679: Instruction result argument can not be null");
        this.m_startInstruction = startInstruction;
        this.m_trackedRegister = trackedRegister;
        this.m_instructionResult = instructionResult;
    }

    private static int getStatusValue(INaviInstruction startInstruction, String trackedRegister, CInstructionResult result) {
        if (startInstruction == result.getInstruction()) {
            return 0;
        }
        if (result.undefinesAll()) {
            return 1;
        }
        if (result.getUndefinedRegisters().contains(trackedRegister)) {
            return 2;
        }
        if (result.undefinesSome()) {
            return 3;
        }
        return 4;
    }

    @Override
    public int compareTo(CResultColumnWrapper o2) {
        return CResultColumnWrapper.getStatusValue(this.getStartInstruction(), this.getTrackedRegister(), this.getResult()) - CResultColumnWrapper.getStatusValue(o2.getStartInstruction(), o2.getTrackedRegister(), o2.getResult());
    }

    public CInstructionResult getResult() {
        return this.m_instructionResult;
    }

    public INaviInstruction getStartInstruction() {
        return this.m_startInstruction;
    }

    public String getTrackedRegister() {
        return this.m_trackedRegister;
    }
}

