/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CInstructionResult;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import java.awt.Color;

public final class CResultColor {
    private CResultColor() {
    }

    public static Color determineBackgroundColor(INaviInstruction startInstruction, String trackedRegister, CInstructionResult result) {
        Preconditions.checkNotNull(startInstruction, "IE01671: Start instruction argument can not be null");
        Preconditions.checkNotNull(trackedRegister, "IE01672: Tracked register argument can not be null");
        Preconditions.checkNotNull(result, "IE01673: Result argument can not be null");
        if (result.getInstruction() == startInstruction) {
            return Color.decode("0x00BF00");
        }
        if (result.undefinesAll()) {
            return Color.decode("0xB30000");
        }
        if (result.clearsTrackedRegister(trackedRegister)) {
            return Color.decode("0xA12967");
        }
        if (result.undefinesSome()) {
            return Color.decode("0xED693F");
        }
        if (result.defines()) {
            return Color.decode("0xFFCD55");
        }
        if (result.updates()) {
            return Color.decode("0x5AAB47");
        }
        if (result.uses()) {
            return Color.decode("0x414142");
        }
        return Color.WHITE;
    }

    public static Color determineForegroundColor(INaviInstruction startInstruction, String trackedRegister, CInstructionResult result) {
        Preconditions.checkNotNull(startInstruction, "IE01674: Start instruction argument can not be null");
        Preconditions.checkNotNull(trackedRegister, "IE01675: Tracked register argument can not be null");
        Preconditions.checkNotNull(result, "IE01676: Result argument can not be null");
        if (result.getInstruction() == startInstruction) {
            return Color.BLACK;
        }
        if (result.undefinesAll()) {
            return Color.WHITE;
        }
        if (result.clearsTrackedRegister(trackedRegister)) {
            return Color.WHITE;
        }
        if (result.undefinesSome()) {
            return Color.BLACK;
        }
        if (result.defines()) {
            return Color.BLACK;
        }
        if (result.updates()) {
            return Color.BLACK;
        }
        if (result.uses()) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }
}

