/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.ITypeDescription;
import com.google.security.zynamics.binnavi.Gui.SettingsDialog.CHintCreator;
import com.google.security.zynamics.zylib.gui.ColorPanel.ColorPanel;
import com.google.security.zynamics.zylib.gui.ColorPanel.IColorPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class COptionsPanel
extends JPanel {
    private static final long serialVersionUID = 4192775617682584194L;
    private static final int COLORPANEL_WIDTH = 200;
    private static final int COLORPANEL_HEIGHT = 25;
    private final Map<ColorPanel, IColorPanelListener> m_listenerMap = new HashMap<ColorPanel, IColorPanelListener>();

    public COptionsPanel(List<ITypeDescription> descriptions) {
        super(new BorderLayout());
        Preconditions.checkNotNull(descriptions, "IE00667: Descriptions argument can not be null");
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel innerMainPanel = new JPanel(new GridBagLayout());
        JPanel functionTypeColorPanel = new JPanel(new GridLayout(descriptions.size(), 1, 3, 3));
        for (ITypeDescription description : descriptions) {
            ColorPanel colorPanel = new ColorPanel(description.getColor(), true, true);
            InternalColorPanelListener listener = new InternalColorPanelListener(description);
            colorPanel.addListener(listener);
            this.m_listenerMap.put(colorPanel, listener);
            this.buildRow(functionTypeColorPanel, description, description.getHint(), colorPanel, false);
        }
        functionTypeColorPanel.setBorder(new TitledBorder("Colors"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        innerMainPanel.add((Component)functionTypeColorPanel, constraints);
        mainPanel.add((Component)innerMainPanel, "North");
        this.add(new JScrollPane(mainPanel));
    }

    private <T extends Component> T buildRow(JPanel panel, ITypeDescription description, String hint, T component, boolean isLast) {
        component.setPreferredSize(new Dimension(200, 25));
        JPanel rowPanel = new JPanel(new BorderLayout());
        rowPanel.setBorder(new EmptyBorder(0, 2, isLast ? 2 : 0, 2));
        JPanel innerPanel = new JPanel(new GridLayout(1, 2));
        innerPanel.add((Component)new JCheckBox(new CheckboxAction(description, String.valueOf(description.getDescription()).concat(":"))), "Center");
        innerPanel.add(CHintCreator.createHintPanel(component, hint), "East");
        rowPanel.add((Component)innerPanel, "West");
        panel.add(rowPanel);
        return component;
    }

    public void dispose() {
        for (Map.Entry<ColorPanel, IColorPanelListener> entry : this.m_listenerMap.entrySet()) {
            entry.getKey().removeListener(entry.getValue());
        }
    }

    private static class InternalColorPanelListener
    implements IColorPanelListener {
        private final ITypeDescription m_description;

        public InternalColorPanelListener(ITypeDescription description) {
            this.m_description = description;
        }

        @Override
        public void changedColor(ColorPanel panel) {
            this.m_description.setColor(panel.getColor());
        }
    }

    private static class CheckboxAction
    extends AbstractAction {
        private static final long serialVersionUID = -4179349114755180229L;
        private final ITypeDescription m_type;

        public CheckboxAction(ITypeDescription type, String string2) {
            super(string2);
            this.m_type = type;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_type.setEnabled(((JCheckBox)event.getSource()).isSelected());
        }
    }
}

