/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.IResultsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.IResultsPanelListener;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CBottomPanel
extends JPanel {
    private static final long serialVersionUID = -1690375770284161511L;
    private final IFilledList<IResultsPanel> m_factory;
    private final JTabbedPane m_tabbedPane = new JTabbedPane();
    private final IResultsPanelListener m_internalPanelListener = new InternalPanelListener();

    public CBottomPanel(IFilledList<IResultsPanel> panels) {
        super(new BorderLayout());
        Preconditions.checkNotNull(panels, "IE01658: Panels can't be null");
        this.m_factory = new FilledList<IResultsPanel>((Collection<IResultsPanel>)panels);
        for (IResultsPanel panel : panels) {
            panel.addListener(this.m_internalPanelListener);
        }
        this.createGui();
    }

    private void createGui() {
        for (IResultsPanel panel : this.m_factory) {
            this.m_tabbedPane.addTab(panel.getTitle(), panel.getComponent());
        }
        this.add((Component)this.m_tabbedPane, "Center");
        this.m_tabbedPane.setVisible(true);
    }

    protected void disposeInternal() {
    }

    public final void addTab(String title, JComponent component) {
        Preconditions.checkNotNull(title, "IE01228: Title argument can not be null");
        Preconditions.checkNotNull(component, "IE01229: Component argument can not be null");
        this.m_tabbedPane.addTab(title, component);
    }

    public final void dispose() {
        for (IResultsPanel panel : this.m_factory) {
            panel.removeListener(this.m_internalPanelListener);
            panel.dispose();
        }
        this.disposeInternal();
    }

    public final void selectTab(JComponent component) {
        Preconditions.checkNotNull(component, "IE01230: Component argument can not be null");
        this.m_tabbedPane.setSelectedComponent(component);
    }

    private class InternalPanelListener
    implements IResultsPanelListener {
        private InternalPanelListener() {
        }

        @Override
        public void show(JComponent panel) {
            CBottomPanel.this.selectTab(panel);
        }
    }
}

