/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphFreezer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public final class CActionFreezeView
extends AbstractAction {
    private static final long serialVersionUID = -4614240922663437427L;
    private final ZyGraph m_graph;
    private JButton m_ParentButton = null;

    public CActionFreezeView(ZyGraph graph) {
        this.m_graph = Preconditions.checkNotNull(graph, "IE02818: graph argument can not be null");
        this.putValue("ShortDescription", "Freeze view");
        this.putValue("SmallIcon", new ImageIcon(CMain.class.getResource("data/viewlock_up.jpg")));
    }

    private void selectButton() {
        this.m_ParentButton.setSelected(true);
        this.putValue("Name", "Frozen Proximitry Browsing. Selection changes do not change graph visibility");
        this.putValue("ShortDescription", "Unfreeze Proximitry Browsing. Selection changes will change graph visibility");
        this.m_ParentButton.setSelectedIcon(new ImageIcon(CMain.class.getResource("data/viewlock_up.jpg")));
        this.m_ParentButton.setRolloverSelectedIcon(new ImageIcon(CMain.class.getResource("data/viewlock_hover.jpg")));
        this.m_ParentButton.setPressedIcon(new ImageIcon(CMain.class.getResource("data/viewnavi_down.jpg")));
    }

    private void unselectButton() {
        this.m_ParentButton.setSelected(false);
        this.putValue("Name", "Unfreeze Proximitry Browsing. Selection changes will change graph visibility");
        this.putValue("ShortDescription", "Frozen Proximitry Browsing. Selection changes do not change graph visibility");
        this.m_ParentButton.setIcon(new ImageIcon(CMain.class.getResource("data/viewnavi_up.jpg")));
        this.m_ParentButton.setRolloverIcon(new ImageIcon(CMain.class.getResource("data/viewnavi_hover.jpg")));
        this.m_ParentButton.setPressedIcon(new ImageIcon(CMain.class.getResource("data/viewlock_down.jpg")));
    }

    private void updateButton() {
        if (this.m_ParentButton != null) {
            if (this.m_graph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
                this.selectButton();
            } else {
                this.unselectButton();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CGraphFreezer.toogleProximityFrozen(this.m_graph);
        this.updateButton();
    }

    public void setButton(JButton button) {
        this.m_ParentButton = button;
        this.updateButton();
    }
}

