/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphSettings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CSettingsPanelBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import com.google.security.zynamics.zylib.gui.zygraph.EdgeHidingMode;
import com.google.security.zynamics.zylib.resources.Constants;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.border.TitledBorder;

public final class CEdgePanel
extends CAbstractSettingsPanel {
    private final JComboBox<String> m_cbDisplayMultiEdgesAsOne = new JComboBox();
    private final JComboBox<String> m_cbDrawSelectedBends = new JComboBox();
    private final JComboBox<String> m_cbEdgeHidingMode = new JComboBox();
    private final JFormattedTextField m_tfEdgeHidingThreshold = new JFormattedTextField(new CDecFormatter(6));

    public CEdgePanel(ZyGraphViewSettings settings) {
        super(new GridLayout(4, 1));
        Preconditions.checkNotNull(settings, "IE01585: Settings argument can not be null");
        this.setBorder(new TitledBorder("Edge Settings"));
        String[] modes = new String[]{Constants.HIDE_NEVER, Constants.HIDE_ALWAYS, Constants.THRESHOLD};
        int selectionIndex = settings.getEdgeSettings().getEdgeHidingMode().ordinal();
        CSettingsPanelBuilder.addComboBox(this, this.m_cbDisplayMultiEdgesAsOne, "Display multiple edges as one:", "If enabled, only one edge between two nodes is shown even if more than one edge connects the two nodes.\nThis is especially useful for cutting down on the number of edges in callgraphs.", settings.getEdgeSettings().getDisplayMultipleEdgesAsOne());
        CSettingsPanelBuilder.addComboBox(this, this.m_cbDrawSelectedBends, "Draw Selected Bends:", "If enabled, corners of selected edges are highlighted.", settings.getEdgeSettings().getDrawSelectedBends());
        CSettingsPanelBuilder.addComboBox(this, this.m_cbEdgeHidingMode, "Hide Edges when zoomed out:", "Specifies under what circumstances edges are not drawn when the graph is zoomed out.", modes, selectionIndex);
        CSettingsPanelBuilder.addTextField(this, this.m_tfEdgeHidingThreshold, "Edge Hiding Threshold when zoomed out:", "If threshold mode is enabled, edges are automatically hidden when more than the specified number of edges are visible.", String.format("%d", settings.getEdgeSettings().getEdgeHidingThreshold()));
    }

    @Override
    public boolean updateSettings(ZyGraphViewSettings settings) {
        boolean needsLayouting = settings.getEdgeSettings().getDisplayMultipleEdgesAsOne() != (this.m_cbDisplayMultiEdgesAsOne.getSelectedIndex() == 0) || settings.getEdgeSettings().getDrawSelectedBends() != (this.m_cbDrawSelectedBends.getSelectedIndex() == 0) || settings.getEdgeSettings().getEdgeHidingMode() != EdgeHidingMode.parseInt(this.m_cbEdgeHidingMode.getSelectedIndex()) || settings.getEdgeSettings().getEdgeHidingThreshold() != Integer.parseInt(this.m_tfEdgeHidingThreshold.getText());
        settings.getEdgeSettings().setDisplayMultipleEdgesAsOne(this.m_cbDisplayMultiEdgesAsOne.getSelectedIndex() == 0);
        settings.getEdgeSettings().setDrawSelectedBends(this.m_cbDrawSelectedBends.getSelectedIndex() == 0);
        settings.getEdgeSettings().setEdgeHidingMode(EdgeHidingMode.parseInt(this.m_cbEdgeHidingMode.getSelectedIndex()));
        settings.getEdgeSettings().setEdgeHidingThreshold(Integer.parseInt(this.m_tfEdgeHidingThreshold.getText()));
        return needsLayouting;
    }
}

