/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.FunctionSelection;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.FunctionSelection.CFunctionIconNode;
import com.google.security.zynamics.binnavi.Gui.FunctionSelection.IActionProvider;
import com.google.security.zynamics.binnavi.Gui.FunctionSelection.IFunctionTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.gui.jtree.IconNode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;

public final class CModuleNode
extends IconNode
implements IFunctionTreeNode {
    private static final long serialVersionUID = -7938396730896978085L;
    private static final ImageIcon ICON_MODULE = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module.png"));
    private static final ImageIcon ICON_MODULE_GRAY = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module_gray.png"));
    private final INaviModule m_module;
    private final DefaultTreeModel m_model;
    private final IActionProvider m_actionProvider;
    private final IModuleListener m_internalModuleListener = new InternalModuleListener();

    public CModuleNode(INaviModule module, DefaultTreeModel model, IActionProvider actionProvider) {
        Preconditions.checkNotNull(module, "IE01577: Module argument can not be null");
        Preconditions.checkNotNull(model, "IE01578: Model argument can not be null");
        Preconditions.checkNotNull(actionProvider, "IE01579: Action provider argument can not be null");
        this.m_module = module;
        this.m_model = model;
        this.m_actionProvider = actionProvider;
        this.m_module.addListener(this.m_internalModuleListener);
        this.createChildren();
    }

    private void createChildren() {
        if (this.m_module.isLoaded()) {
            for (INaviFunction function : this.m_module.getContent().getFunctionContainer().getFunctions()) {
                if (function.getType() == FunctionType.IMPORT) continue;
                this.add(new CFunctionIconNode(function));
            }
        }
    }

    @Override
    public void doubleClicked() {
        if (!this.m_module.isLoaded()) {
            this.m_actionProvider.loadModule(this.m_module);
        }
    }

    @Override
    public Icon getIcon() {
        return this.m_module.isLoaded() ? ICON_MODULE : ICON_MODULE_GRAY;
    }

    @Override
    public String toString() {
        return String.format("%s (%d/%d)", this.m_module.getConfiguration().getName(), this.m_module.getFunctionCount(), this.m_module.getCustomViewCount());
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void addedView(INaviModule module, INaviView view) {
            CModuleNode.this.m_model.nodeChanged(CModuleNode.this);
        }

        @Override
        public void changedName(INaviModule module, String name) {
            CModuleNode.this.m_model.nodeChanged(CModuleNode.this);
        }

        @Override
        public void loadedModule(INaviModule module) {
            CModuleNode.this.createChildren();
            CModuleNode.this.m_model.nodeStructureChanged(CModuleNode.this);
        }
    }
}

