/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.FunctionSelection;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.FunctionSelection.CFunctionSelectionPanel;
import com.google.security.zynamics.binnavi.Gui.FunctionSelection.IActionProvider;
import com.google.security.zynamics.binnavi.Gui.Loaders.CModuleLoader;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JScrollPane;

public final class CFunctionSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 1751648093815840785L;
    private final CFunctionSelectionPanel m_panel;
    private INaviFunction m_function;

    public CFunctionSelectionDialog(Window owner, IDatabase database) {
        super(owner, "Please select a function", Dialog.ModalityType.APPLICATION_MODAL);
        Preconditions.checkNotNull(database, "IE01572: Database argument can not be null");
        this.setLayout(new BorderLayout());
        new CDialogEscaper(this);
        this.m_panel = new CFunctionSelectionPanel(database, new InternalActionProvider());
        this.add(new JScrollPane(this.m_panel));
        this.add((Component)new CPanelTwoButtons(new InternalListener(), "OK", "Cancel"), "South");
        this.setSize(500, 400);
    }

    public INaviFunction getSelectedFunction() {
        return this.m_function;
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                CFunctionSelectionDialog.this.m_function = CFunctionSelectionDialog.this.m_panel.getSelectedFunction();
            }
            CFunctionSelectionDialog.this.dispose();
        }
    }

    private class InternalActionProvider
    implements IActionProvider {
        private InternalActionProvider() {
        }

        @Override
        public void loadModule(INaviModule module) {
            CModuleLoader.loadModule(CFunctionSelectionDialog.this, module);
        }
    }
}

