/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.CInstructionFilterExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.ConcreteTree.IFilterExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.IPredicateGenerator;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.Wrappers.CViewWrapper;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CInstructionGenerator
implements IPredicateGenerator<CViewWrapper> {
    private static final String RULE_REGEX = "\\s*contains\\s*(==)\\s*([0-9A-Fa-f]+)\\s*";
    private final IViewContainer m_container;

    public CInstructionGenerator(IViewContainer container) {
        this.m_container = container;
    }

    @Override
    public boolean canParse(String text2) {
        return text2.matches(RULE_REGEX);
    }

    @Override
    public IFilterExpression<CViewWrapper> createExpression(String text2) {
        Pattern pattern = Pattern.compile(RULE_REGEX);
        Matcher matcher = pattern.matcher(text2);
        matcher.matches();
        String value = matcher.group(2);
        try {
            List<INaviView> views = this.m_container.getViewsWithAddresses(Lists.newArrayList(new UnrelocatedAddress(new CAddress(new BigInteger(value, 16)))), true);
            return new CInstructionFilterExpression(views);
        }
        catch (CouldntLoadDataException e2) {
            return null;
        }
    }
}

