/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.DebuggerComboBox;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.DebuggerComboBox.CDebuggerTemplateWrapper;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.IDebuggerContainer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.IDebuggerContainerListener;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class CDebuggerComboModel
implements ComboBoxModel<CDebuggerTemplateWrapper> {
    private final IDebuggerContainer debuggerContainer;
    private CDebuggerTemplateWrapper selectedItem;
    private final ListenerProvider<ListDataListener> modelListeners = new ListenerProvider();
    private final InternalDebuggerContainerListener debuggerListener = new InternalDebuggerContainerListener();
    private final List<CDebuggerTemplateWrapper> comboboxElements = new ArrayList<CDebuggerTemplateWrapper>();

    public CDebuggerComboModel(IDebuggerContainer debuggerContainer) {
        this.debuggerContainer = Preconditions.checkNotNull(debuggerContainer, "IE01570: Debugger container argument can not be null");
        debuggerContainer.addListener(this.debuggerListener);
        this.updateElements();
    }

    private void updateElements() {
        this.comboboxElements.clear();
        this.comboboxElements.add(new CDebuggerTemplateWrapper(null));
        for (DebuggerTemplate template : this.debuggerContainer.getDebuggers()) {
            this.comboboxElements.add(new CDebuggerTemplateWrapper(template));
        }
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.modelListeners.addListener(listener);
    }

    @Override
    public CDebuggerTemplateWrapper getElementAt(int index) {
        return this.comboboxElements.get(index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.comboboxElements.size();
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.modelListeners.removeListener(listener);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = (CDebuggerTemplateWrapper)anItem;
    }

    private class InternalDebuggerContainerListener
    implements IDebuggerContainerListener {
        private InternalDebuggerContainerListener() {
        }

        @Override
        public void addedDebugger(IDebuggerContainer container, DebuggerTemplate debugger) {
            CDebuggerComboModel.this.updateElements();
            for (ListDataListener listener : CDebuggerComboModel.this.modelListeners) {
                listener.contentsChanged(new ListDataEvent(CDebuggerComboModel.this, 0, 0, CDebuggerComboModel.this.getSize()));
            }
        }

        @Override
        public void removedDebugger(IDebuggerContainer container, DebuggerTemplate debugger) {
            CDebuggerComboModel.this.updateElements();
            for (ListDataListener listener : CDebuggerComboModel.this.modelListeners) {
                listener.contentsChanged(new ListDataEvent(CDebuggerComboModel.this, 0, 0, CDebuggerComboModel.this.getSize()));
            }
        }
    }
}

