/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.TraceOptionsDialog;

import com.google.security.zynamics.zylib.gui.CDecFormatter;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class CTraceOptionsDialog
extends JDialog {
    private static final long serialVersionUID = 4756716971206634975L;
    private final JFormattedTextField m_maximumHitsField = new JFormattedTextField(new CDecFormatter(4));
    private boolean m_wasCancelled = false;
    private int m_maximumHits;

    private CTraceOptionsDialog(Window parent) {
        super(parent, "Trace Options", Dialog.ModalityType.DOCUMENT_MODAL);
        this.setLayout(new BorderLayout());
        this.m_maximumHitsField.setText("1");
        JPanel upperPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new GridLayout(1, 1));
        innerPanel.add(this.createPanel("Maximum Hits", this.m_maximumHitsField));
        upperPanel.add((Component)innerPanel, "North");
        upperPanel.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new TitledBorder("")));
        this.add(upperPanel);
        CPanelTwoButtons panel = new CPanelTwoButtons(new InternalListener(), "OK", "Cancel");
        this.getRootPane().setDefaultButton(panel.getFirstButton());
        this.add((Component)panel, "South");
        this.setSize(400, 200);
    }

    public static CTraceOptionsDialog show(JFrame parent) {
        CTraceOptionsDialog dlg = new CTraceOptionsDialog((Window)parent);
        GuiHelper.centerChildToParent(parent, dlg, true);
        dlg.setVisible(true);
        return dlg;
    }

    private Component createPanel(String description, JComponent component) {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(new JLabel(description));
        panel.add(component);
        return panel;
    }

    public int getMaximumHits() {
        return this.m_maximumHits;
    }

    public boolean wasCancelled() {
        return this.m_wasCancelled;
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            block4: {
                if (event.getActionCommand().equals("OK")) {
                    try {
                        CTraceOptionsDialog.this.m_maximumHits = Integer.valueOf(CTraceOptionsDialog.this.m_maximumHitsField.getText());
                        if (CTraceOptionsDialog.this.m_maximumHits > 1000) {
                            CMessageBox.showInformation(CTraceOptionsDialog.this, "Maximum hit count can not be higher than 1000.");
                            return;
                        }
                        break block4;
                    }
                    catch (NumberFormatException exception) {
                        CMessageBox.showInformation(CTraceOptionsDialog.this, String.format("Invalid maximum hit count string '%s'", CTraceOptionsDialog.this.m_maximumHitsField.getText()));
                        return;
                    }
                }
                CTraceOptionsDialog.this.m_wasCancelled = true;
            }
            CTraceOptionsDialog.this.dispose();
        }
    }
}

