/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugEventListenerAdapter;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceLogger;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CStopTraceListener
extends CEndlessHelperThread {
    private final IDebugger m_debugger;
    private final TraceLogger m_logger;
    private Set<BreakpointAddress> m_removedAddresses = null;
    private boolean m_isDone = false;
    private final List<EchoBreakpointsRemovedReply> m_bufferedReplies = new ArrayList<EchoBreakpointsRemovedReply>();
    private final IDebugEventListener m_debuggerListener = new DebugEventListenerAdapter(){

        @Override
        public void debuggerClosed(int code2) {
            CStopTraceListener.this.m_isDone = true;
        }

        @Override
        public void receivedReply(EchoBreakpointsRemovedReply reply) {
            if (CStopTraceListener.this.m_removedAddresses == null) {
                CStopTraceListener.this.m_bufferedReplies.add(reply);
            } else {
                CStopTraceListener.this.m_isDone = CStopTraceListener.this.checkReply(reply);
            }
        }
    };

    public CStopTraceListener(IDebugger debugger, TraceLogger logger) {
        Preconditions.checkNotNull(logger, "IE01565: Logger argument can not be null");
        this.m_debugger = debugger;
        this.m_logger = logger;
        debugger.addListener(this.m_debuggerListener);
    }

    private boolean checkReply(EchoBreakpointsRemovedReply reply) {
        List<Pair<RelocatedAddress, Integer>> receivedAddresses = reply.getAddresses();
        if (receivedAddresses.size() != this.m_removedAddresses.size()) {
            for (Pair<RelocatedAddress, Integer> pair : receivedAddresses) {
                RelocatedAddress receivedAddress = pair.first();
                if (this.m_removedAddresses.contains(DebuggerHelpers.getBreakpointAddress(this.m_debugger, receivedAddress))) continue;
                String string2 = String.valueOf("IE00680: the number of breakpoints removed differs from the number of received breakpoints in the debugger reply\nThe first breakpoint address missmatch is:");
                String string3 = String.valueOf(DebuggerHelpers.getBreakpointAddress(this.m_debugger, receivedAddress));
                throw new IllegalStateException(new StringBuilder(0 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(string3).toString());
            }
        }
        return true;
    }

    @Override
    protected void runExpensiveCommand() throws Exception {
        this.m_removedAddresses = new HashSet<BreakpointAddress>(this.m_logger.stop());
        for (EchoBreakpointsRemovedReply reply : this.m_bufferedReplies) {
            this.m_isDone |= this.checkReply(reply);
        }
        while (!this.m_isDone) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }
        this.m_debugger.removeListener(this.m_debuggerListener);
    }
}

